	   *************************************************
	 *******				       *******	
	*******         K I L L I N G  S P R E E        *******
	*******						*******
	*******  THE 2ND GAME BY LOST BOYS DEVELOPMENT  *******
	*******         REDUCED MAP SIZE VERSION        *******
	*******						*******
	*******	        L E V E L   E D I T O R	        *******
         *******                                       *******
           *************************************************
**********************************************************************
* THE FOLLOWING TEXT TAKES THE FORM OF AN INSTRUCTION MANUAL FOR THE *
*      KILLING SPREE LEVEL EDITOR. ALL CODING WAS BY MANIKIN.        *
**********************************************************************

*  THE MAIN MENU ALLOWS THE ALTERATION OF THE SETUP PARAMETERS
* WHICH CAN BE USED TO CAUSE DIFFERENT EFFECTS IN THE CALCULATED
* FRACTAL. FUNCTION KEYS INCREASE PARAMETERS, SHIFT + FUCTION
* KEYS DECREASE PARAMETERS
*
* 'COMPRESSED' FILE FORMAT = 512 BYTE SET UP DATA
*		        ???? BYTE SPOT THE DIFFERENCE DATA FILE
*			2 BYTES OFFSET. 4 BYTES DATA
* CONTROLS:-
*		THE 3D VIEWER   (F2)
*
* USE ALL THE ARROW KEYS TO MOVE IN ANY DIRECTION 
*
*		THE 2D VIEWER   (F1)
*
* USE THE MOUSE TO MOVE THE CURSOR AROUND THE SCREEN. MOVING TO TOP
* OR BOTTOM WILL ALLOW YOU TO SCROLL UP OR DOWN THE MAP. PRESSING
* KEYS  ESC - BACKSPACE WILL ALTER THE COLOR OF THE SQUARE TO THE 
* IN DICATED COLOR (SEE PANEL). PRESSING KEYS TAB - U WILL CHANGE
* NOT ONLY THE COLOR BUT ALSO THE HEIGHT. 
* PRESSING H AND ONE OF THE ABOVE KEYS WILL CREATE A
* HORIZONTAL LINE OF COLOR OR HEIGHT. PRESSING V WILL CREATE A VERTICAL
* LINE IN THE SAME MANNER.
* PRESSING THE C KEY FOLLOWED BY A KEY FROM TAB - U WILL MAKE A 
* SPIRE OF THAT PARTICULAR HEIGHT
* PRESSING THE UNDO KEY WILL REPLACE THE ENTIRE LINE THAT THE CURSOR
* IS CURRENTLY ON WITH THE ORIGINAL FRACTAL DATA,COLORS AND BLANK
* OBJECT LINE.
* PRESSING THE * KEY ON THE KEYPAD T W I C E WILL RETURN THE ENTIRE
* FRACTAL TO ITS ORIGINAL STATE. I.E. REMOVE ALL THE CHANGES MADE.
* TO FILL AN ENTIRE AREA IN A PARTICULAR COLOR, PLACE THE CURSOR
* ANYWHERE IN THE AREA YOU WISH TO COLOR. THEN PRESS THE KEY F AND 
* ALSO THE KEY CORRESPONDING TO THE COLOR THAT YOU WANT TO FILL THE AREA.
* TO SET THE START POSITION ON THE MAP PRESS THE S KEY AND A SMALL
* S WILL APPEAR ON THE MAP. THIS IS THEN WHERE THE SHIP WILL INITIALLY
* START FROM ON THE LEVEL
*
* THE OBJECT EDITING PART OF THE 2D MAP VIEWER
*
* PRESS 'P' TO POSITION AN OBJECT ON THE MAP
* + & - ON THE KEYPAD CHANGE THE OBJECT TO BE POSITIONED.
*
*		THE COMPLETE MAP (F3)
*
* PRESSING ONE OF THE KEYS 1-4 WILL CHANGE THE WAY THAT THE FRACTAL
* IS CURRENTLY FILLED.
*
* 1 = FILL ACCORDING TO HEIGHT (4 COORD)
* 2 = FILL ACCORDING TO HEIGHT (2 COORD)
* 3 = ************* NOTHING ANYMORE
* 4 = SHADE WITH LIGHT SOURCE
*
*  W A R N I N G   ANY ALTERATIONS WILL NOT 
* BE TAKEN INTO ACCOUNT AND THE COMPUTER WILL SIMPLY COLOR THEM 
* ACCORDING TO PRESENT HEIGHT NOT PREVIOUS COLOR
* ALSO THE PROCEDURE IS IRREVERSIBLE AND C A N N O T BE UNDONE!
* THIS IS BECAUSE OTHERWISE WHEN SAVING IN SMALL FORMAT IT WOULD
* SAVE ALL THE COLOR DATA WHICH RATHER DEFEATS THE OBJECT!
* THE VIEWING BOX CAN BE MOVED UP AND DOWN THE MAP USING THE ARROW
* KEYS. THIS BOX REPRESENTS THE CURRENT EDITING POSITION ON THE MAP
* AND ON RETURNING TO THE 2D VIEWER THIS IS WHAT WILL BE DISPLAYED.
* THE VIEWING BOX CAN ALSO SKIP BETWEEN LINES USING THE LEFT AND RIGHT
* ARROW KEYS.
*
* THE COLOR EDITOR (F4)
*
* SELECT COLOR USING LEFT AND RIGHT ARROW KEYS. THEN CHANGE RED,
* GREEN AND BLUE HUES BYPRESSING THE KEYS 1,2 AND 3.
* NOTE IT IS NOT POSSIBLE TO CHANGE INTERLACED HUES.
*
* THE RASTER EDITOR (F5)
*
* EDITING OF THE BACKGROUND RASTERS CAN BE DONE USING THIS OPTION
* THE UP AND DOWN ARROW KEYS SELECT THE LINE TO BE EDITED.
* RED GREEN AND BLUE HUES CAN BE CONTROLLED USING THE KEYS 1,2 AND 3
* JUST AS IN THE COLOR EDITOR. * ON THE KEY PAD BLANKS ALL RASTERS 
* TO BLACK.
*
* THE GAME PRESET EDITOR (F6)
*
* ALLOWS EDITING OF GAME PRESETS SUCH AS LEVEL COMPLETION TIME, ENEMY
* FIRE RATE ETC
*
* LOADING AND SAVING
*
* JUST TYPE IN THE FILENAME OF THE MAP THAT YOU WISH TO LOAD
* THE EDITOR DOES NOT CHECK THE FORMAT OF THE FILE SO DON'T 
* TRY LOADING FILES WHICH ARE NOT MAPS COS YOU'LL CRASH IT!

		OPT	O+

GRID_SIZE:	EQU	32 
MEM:		EQU	$180000
GENST		EQU	1
SCREEN1:	EQU	$68000+MEM
SCREEN2:	EQU	$70000+MEM
SCREEN3:	EQU	$78000+MEM
MAX_SPEED:	EQU	3	(MAXIMUM FRAME COUNT SPEED)
MAX_HEIGHT:	EQU	150
NUMBER_OF_OBJECTS:	EQU	23

	JMP	START

SET_UP_DATA:
WATER_LEVEL:	DC.W	1100
RANDOM_FAC:	DC.W	7000
LAND_LEVEL:	DC.W	600
RANDOM_NUMBER:	DC.L	$FEDCBA98
CREATION_STYLE:	DC.W	1	0 = ISLANDS, 1 = CANYON, 2 = BLANK, 3 = DEEP VALLEY
FILL_STYLES:	DC.W	1	1 = HEIGHT(4) 2 = HEIGHT (1) 3 = RANDOM 4=LIGHT
RIVER_HEIGHT:	DC.W	730	ONLY APPLICABLE WHEN CANYON IS ACTIVATED

PALETTE:	DC.W	$0000,$0003,$0120,$0340,$0200,$0310,$0420,$0530	
		DC.W	$0651,$0313,$0230,$0451,$0667,$0446,$0335,$0223	
RASTERS:	DS.W	60
SHIP_START_X:	DC.W	0
SHIP_START_Z:	DC.W	0
FIRE_REPEAT:	DC.W	50	(SECS = FR/3)
LEVEL_TIME:	DC.W	120	(TIME IN SECONDS)
	DS.B	512-120

START:
	CLR.L	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,OLDSSP
	LEA	OURSTACK,A7

	MOVEM.L	$FFFF8240.W,D0-D7
	MOVEM.L	D0-D7,OLD_PALETTE
	MOVE.L	$FFFF8200.W,OLD_PHYS

	MOVE.W	#0,-(SP)
	MOVE.L	#SCREEN1,-(SP)
	MOVE.L	#SCREEN1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	
	MOVEM.L	PALETTE(PC),D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	BSR	CLEAR_SCREENS

	LEA	KEYBOARD_ON(PC),A0
	BSR 	IKBD	

	BSR	HBL_ON
	BSR	PREPARE_GRID_MULT
	BSR	PREPARE_PROJ_DIVU
	BSR	MAKE_PRE_CALC_TABLE
	LEA	MENU_TEXT(PC),A0
	LEA	TEXT(PC),A1
	BSR	DRAW_OUT_TEXT
	BSR	DRAW_BIT_OF_TEXT
MAIN_MENU:
	MOVE.L	#MAIN_VBL,$70.W
	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W
	BSR	CLEAR_SCREENS
	LEA	CREATION_LIST(PC),A0
	MOVE.W	CREATION_STYLE(PC),D7
	LSL.W	#3,D7
	MOVE.L	(A0,D7.W),MAIN_TEXT_CREATION
	MOVE.L	4(A0,D7.W),MAIN_TEXT_CREATION+4
	LEA	FILL_LIST(PC),A0
	MOVE.W	FILL_STYLES(PC),D7
	LSL.W	#3,D7
	MOVE.L	(A0,D7.W),MAIN_TEXT_FILL
	MOVE.L	4(A0,D7.W),MAIN_TEXT_FILL+4
	BSR	DRAW_ON_MAIN_TEXT	

.MAIN_LOOP:
	TST.W	VBL_COUNT
	BEQ.S	.MAIN_LOOP
	CLR.W	VBL_COUNT
	BSR	DO_BULLSHIT
	TST.W	REDRAW_TEXT
	BEQ.S	.NOPE
	BSR	DRAW_ON_MAIN_TEXT
	CLR.W	REDRAW_TEXT
.NOPE:
	MOVEQ	#0,D0
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$3B,D0				F1
	BEQ	DO_FRACTAL_CALC
	TST.W	DATA_TO_DECOMPRESS
	BEQ.S	.NONE
	CMP.B	#$3C,D0
	BEQ	DO_FRACTAL_CALC2		F2
.NONE
	CMP.B	#$3D,D0				F3
	BEQ	LOAD_SMALL_MAP
	CMP.B	#$3E,D0				F4
	BNE.S	.NEXT_KEY_TEST
	CLR.W	KBUFF
	ADDQ.W	#1,CREATION_STYLE
	CMP.W	#5,CREATION_STYLE
	BNE.S	.NEXT_KEY_TEST1B
	CLR.W	CREATION_STYLE
.NEXT_KEY_TEST1B
	LEA	CREATION_LIST(PC),A0
	MOVE.W	CREATION_STYLE(PC),D7
	LSL.W	#3,D7
	MOVE.L	(A0,D7.W),MAIN_TEXT_CREATION
	MOVE.L	4(A0,D7.W),MAIN_TEXT_CREATION+4
	ST	REDRAW_TEXT
.NEXT_KEY_TEST:
	CMP.B	#$3F,D0				F5
	BNE.S	.NEXT_KEY_TEST2
	CLR.W	KBUFF
	ADDQ.W	#1,FILL_STYLES
	CMP.W	#5,FILL_STYLES
	BNE.S	.NEXT_KEY_TEST2B
	MOVE.W	#1,FILL_STYLES
.NEXT_KEY_TEST2B:
	LEA	FILL_LIST(PC),A0
	MOVE.W	FILL_STYLES(PC),D7
	LSL.W	#3,D7
	MOVE.L	(A0,D7.W),MAIN_TEXT_FILL
	MOVE.L	4(A0,D7.W),MAIN_TEXT_FILL+4
	ST	REDRAW_TEXT
.NEXT_KEY_TEST2:
	CMP.B	#$40,D0				F6
	BNE.S	.NEXT_KEY_TEST3
	TST.B	KEY_BUFFER+$2A
	BEQ.S	.UP1
	SUBQ.W	#2,WATER_LEVEL
	BNE.S	.NEXT_KEY_TEST3
	MOVE.W	#2000,WATER_LEVEL
	BRA.S	.NEXT_KEY_TEST3
.UP1
	ADDQ.W	#2,WATER_LEVEL
	CMP.W	#2000,WATER_LEVEL
	BNE.S	.NEXT_KEY_TEST3
	MOVE.W	#0,WATER_LEVEL
.NEXT_KEY_TEST3:
	CMP.B	#$41,D0				F7
	BNE.S	.NEXT_KEY_TEST4
	TST.B	KEY_BUFFER+$2A
	BEQ.S	.UP2
	SUBQ.W	#2,LAND_LEVEL
	BNE.S	.NEXT_KEY_TEST4
	MOVE.W	#2000,LAND_LEVEL
	BRA.S	.NEXT_KEY_TEST4
.UP2:
	ADDQ.W	#2,LAND_LEVEL
	CMP.W	#2000,LAND_LEVEL
	BNE.S	.NEXT_KEY_TEST4
	MOVE.W	#0,LAND_LEVEL
.NEXT_KEY_TEST4:
	CMP.B	#$42,D0				F8
	BNE.S	.NEXT_KEY6
	CLR.W	KBUFF
	BSR	RANDOM2
.NEXT_KEY6:
	CMP.B	#$43,D0				F9
	BNE.S	.NEXT_KEY_TEST5
	TST.B	KEY_BUFFER+$2A
	BEQ.S	.UP3
	SUBQ.W	#5,RANDOM_FAC
	BNE.S	.NEXT_KEY_TEST5
	MOVE.W	#10000,RANDOM_FAC
	BRA.S	.NEXT_KEY_TEST5
.UP3
	ADDQ.W	#5,RANDOM_FAC
	CMP.W	#10000,RANDOM_FAC
	BNE.S	.NEXT_KEY_TEST5
	MOVE.W	#0,RANDOM_FAC
.NEXT_KEY_TEST5:
	CMP.B	#$44,D0				F10
	BEQ	QUIT	
	BRA	.MAIN_LOOP

REDRAW_TEXT:	DC.W	0

CREATION_LIST:
	DC.B	" ISLANDS"
	DC.B	"  CANYON"
	DC.B	"   BLANK"
	DC.B	"DEEP VAL"
	DC.B	"TRENCH  "

FILL_LIST:
	DS.B	8
	DC.B	"HEIGHT 2"
	DC.B	"HEIGHT 4"
	DC.B	"       -"
	DC.B	"   LIGHT"
 
DO_FRACTAL_CALC:
	BSR	CLEAR_SCREENS
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CALC_PLAY_AREA
	BSR	COPY_TO_RESERVE
	BRA.S	DRAW_REAL_3D

DO_FRACTAL_CALC2:
	BSR	CLEAR_SCREENS
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CALC_PLAY_AREA
	BSR	COPY_TO_RESERVE
	BSR	DECOMPRESS_DATA

*OK HERES WHERE THE PROGRAM STARTS. DEFAULT IS 3D REPRESENTATION
*BUT THEN IT IS UP TO THE USER WHAT TO SELECT NEXT!
******************************************************
* ROUTINE FOR DRAWING A 3D REPRESENTATION OF THE MAP *
******************************************************

DRAW_REAL_3D:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	LEA	MENU_TEXT(PC),A0
	LEA	TEXT(PC),A1
	BSR	DRAW_OUT_TEXT
	BSR	DRAW_ON_TEXT
	MOVE.L	#REAL_3D_VBL,$70.W
.MAIN_LOOP:			
	MOVE.L	#SCREEN2,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W
	MOVE.L	#WATER_DATA2,LOG_WATER
	MOVE.L	#WATER_DATA1,PHYS_WATER

.LOOP	CMP.W	#MAX_SPEED,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK
	BSR	CLEAR_LOGBASE
	BSR	MAKE_DRAW_ARRAY
	BSR	DRAW_3D_VERSION
	BSR	OPTION_ROUTINE

	MOVE.L	#SCREEN3,LOGBASE
	MOVE.L	#SCREEN2,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

	MOVE.L	#WATER_DATA3,LOG_WATER
	MOVE.L	#WATER_DATA2,PHYS_WATER

.LOOP1	CMP.W	#MAX_SPEED,VBL_COUNT
	BLT.S	.LOOP1
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK
	BSR	CLEAR_LOGBASE
	BSR	MAKE_DRAW_ARRAY
	BSR	DRAW_3D_VERSION
	BSR	OPTION_ROUTINE

	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN3,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

	MOVE.L	#WATER_DATA1,LOG_WATER
	MOVE.L	#WATER_DATA3,PHYS_WATER

.LOOP2	CMP.W	#MAX_SPEED,VBL_COUNT
	BLT.S	.LOOP2
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK
	BSR	CLEAR_LOGBASE
	BSR	MAKE_DRAW_ARRAY
	BSR	DRAW_3D_VERSION
	BSR	OPTION_ROUTINE

	BRA	.MAIN_LOOP

******************************************************
* ROUTINE FOR DRAWING A 2D REPRESENTATION OF THE MAP *
******************************************************

DRAW_2D:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	LEA	MENU_TEXT2(PC),A0
	LEA	TEXT(PC),A1
	BSR	DRAW_OUT_TEXT
	BSR	DRAW_ON_TEXT	
	LEA	SET_ABSOLUTE(PC),A0
	BSR 	IKBD	
	MOVE.L	#REAL_2D_VBL,$70.W
.MAIN_LOOP:			
	MOVE.L	#SCREEN2,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK_FOR_MAP
	BSR	DRAW_2D_VERSION
	BSR	OPTION_ROUTINE

	MOVE.L	#SCREEN3,LOGBASE
	MOVE.L	#SCREEN2,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP1	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP1
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK_FOR_MAP
	BSR	DRAW_2D_VERSION
	BSR	OPTION_ROUTINE

	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN3,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP2	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP2
	CLR.W	VBL_COUNT

	BSR	READ_JOYSTICK_FOR_MAP
	BSR	DRAW_2D_VERSION
	BSR	OPTION_ROUTINE

	BRA	.MAIN_LOOP

******************************************************
* ROUTINE FOR DRAWING THE COMPLETE MAP ON THE SCREEN *
******************************************************

DRAW_COMPLETE_MAP:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	MOVE.L	#MAP_VBL,$70.W
	BSR	CALC_THE_MAP
MAIN_MAP_LOOP:			
	MOVE.L	#SCREEN2,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT
	BRA.S	GO_HERE
REDRAW:
	BSR	CALC_THE_MAP
GO_HERE
	BSR	DRAW_THE_MAP
	BSR	MAP_ROUTINE

	MOVE.L	#SCREEN3,LOGBASE
	MOVE.L	#SCREEN2,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP1	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP1
	CLR.W	VBL_COUNT

	BSR	DRAW_THE_MAP
	BSR	MAP_ROUTINE

	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN3,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP2	CMP.W	#1,VBL_COUNT
	BLT.S	.LOOP2
	CLR.W	VBL_COUNT

	BSR	DRAW_THE_MAP
	BSR	MAP_ROUTINE

	BRA	MAIN_MAP_LOOP

******************************************************
* ROUTINE FOR MANIPULATION OF THE COLOR PALETTE      *
******************************************************

RUN_COLOR_EDITOR:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	LEA	MENU_TEXT3(PC),A0
	LEA	TEXT(PC),A1
	BSR	DRAW_OUT_TEXT
	BSR	DRAW_ON_TEXT
	MOVE.L	#REAL_2D_VBL,$70.W

.MAIN_LOOP:			
	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP	CMP.W	#10,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT

	BSR	COLOR_EDITOR
	BSR	EXIT_ROUTINE
	BRA.S	.LOOP

******************************************************
* ROUTINE FOR SETTING GAME PRESETS                   *
******************************************************

DO_GAME_PRESETS:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	MOVE.L	#MAIN_VBL,$70.W
	LEA	PRESET_TEXT(PC),A0
	LEA	SCREEN1,A1
	BSR	DRAW_OUT_TEXT
	MOVE.L	#SCREEN1,D0
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W
MAIN_PRESET_LOOP:			
.LOOP	CMP.W	#2,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT

	LEA	NUMBER_FONT(PC),A3
	MOVE.W	FIRE_REPEAT(PC),D0
	LEA	SCREEN1+(32*160)+128,A0
	BSR	DRAW_4_DIGIT
	MOVE.W	LEVEL_TIME(PC),D0
	LEA	SCREEN1+(40*160)+128,A0
	BSR	DRAW_4_DIGIT

	MOVE.B	KBUFF(PC),D0
	CMP.B	#$2,D0				.1
	BNE.S	.NEXT_KEY_TEST1
	TST.B	KEY_BUFFER+$2A
	BEQ.S	.UP1
	SUBQ.W	#1,FIRE_REPEAT
	BNE.S	.NEXT_KEY_TEST1
	MOVE.W	#200,FIRE_REPEAT
	BRA.S	.NEXT_KEY_TEST1
.UP1:
	ADDQ.W	#1,FIRE_REPEAT
	CMP.W	#200,FIRE_REPEAT
	BNE.S	.NEXT_KEY_TEST1
	MOVE.W	#0,FIRE_REPEAT
.NEXT_KEY_TEST1:
	CMP.B	#$3,D0				.2
	BNE.S	.NEXT_KEY_TEST2
	TST.B	KEY_BUFFER+$2A
	BEQ.S	.UP2
	SUBQ.W	#1,LEVEL_TIME
	BNE.S	.NEXT_KEY_TEST2
	MOVE.W	#600,LEVEL_TIME
	BRA.S	.NEXT_KEY_TEST2
.UP2:
	ADDQ.W	#1,LEVEL_TIME
	CMP.W	#600,LEVEL_TIME
	BNE.S	.NEXT_KEY_TEST2
	MOVE.W	#0,LEVEL_TIME
.NEXT_KEY_TEST2:

	CMP.B	#$1,KBUFF
	BEQ	DRAW_REAL_3D
	BRA	MAIN_PRESET_LOOP

******************************************************
* ROUTINE FOR MANIPULATION OF THE RASTERS PALETTE    *
******************************************************

RUN_RASTER_EDITOR:
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CLEAR_SCREENS
	LEA	MENU_TEXT4(PC),A0
	LEA	TEXT(PC),A1
	BSR	DRAW_OUT_TEXT
	BSR	DRAW_ON_TEXT
	MOVE.L	#REAL_3D_VBL,$70.W
	MOVE.L	#SCREEN1,LOGBASE
	BSR	CLEAR_LOGBASE

.MAIN_LOOP:			
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

.LOOP	CMP.W	#10,VBL_COUNT
	BLT.S	.LOOP
	CLR.W	VBL_COUNT

	BSR	RASTER_EDITOR
	BSR	EXIT_ROUTINE
	BRA.S	.LOOP

****************************************************
* CONTROL ROUTINE TO SAVE THE REDUCED FRACTAL DATA *
****************************************************

RUN_SMALL_SAVE:
	MOVE.L	#DISK_VBL,$70.W	
	BSR	CLEAR_SCREENS

	MOVE.L	#SCREEN1,LOGBASE
	MOVE.L	#SCREEN1,D0
	MOVE.L	D0,PHYSBASE
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

	MOVE.L	OLD_KEY,$118.W
	BSET	#5,$FFFFFA09.W
	BSR	WRITE_TO_DISK_SMALL
	BCLR	#5,$FFFFFA09.W
	MOVE.L	#KEY_VECTOR,$118.W
	BRA	DRAW_REAL_3D

*********************************************************
* THIS DEALS WITH AN EXIT REQUEST FROM A SCREEN WHERE NO*
* OPTIONS ARE AVAILABLE. EG COMPLETE MAP SCREEN         *
*********************************************************

RECOLOR1:	
	BSR	DO_HEIGHT_COLORSA
	BSR	COPY_COLORS_TO_RESERVE
	CLR.W	KBUFF
	BRA	REDRAW

RECOLOR2:	
	BSR	DO_HEIGHT_COLORSB
	BSR	COPY_COLORS_TO_RESERVE
	CLR.W	KBUFF
	BRA	REDRAW

RECOLOR3:	
	BSR	DO_HEIGHT_COLORSA		*SPARE SLOT
	BSR	COPY_COLORS_TO_RESERVE
	CLR.W	KBUFF
	BRA	REDRAW

RECOLOR4:	
	BSR	DO_LIGHT
	BSR	COPY_COLORS_TO_RESERVE
	CLR.W	KBUFF
	BRA	REDRAW

GOING_UP:
	SUBQ.W	#1,CURRENT_POS
	BPL.S	.OK
	CLR.W	CURRENT_POS
.OK
	RTS

GOING_DOWN:
	ADDQ.W	#1,CURRENT_POS
	CMP.W	#499,CURRENT_POS
	BNE.S	.OK
	MOVE.W	#498,CURRENT_POS
.OK	RTS

GOING_LEFT:
	CMP.W	#200,CURRENT_POS
	BLT.S	.NOPE
	CLR.W	KBUFF
	SUB.W	#200,CURRENT_POS
.NOPE	RTS

GOING_RIGHT:
	CMP.W	#298,CURRENT_POS
	BGT.S	.NOPE
	CLR.W	KBUFF
	ADD.W	#200,CURRENT_POS
.NOPE	RTS

MAP_ROUTINE:
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$2,D0
	BEQ	RECOLOR1
	CMP.B	#$3,D0
	BEQ	RECOLOR2
	CMP.B	#$4,D0
	BEQ	RECOLOR3
	CMP.B	#$5,D0
	BEQ	RECOLOR4
	CMP.B	#$48,D0
	BEQ	GOING_UP
	CMP.B	#$50,D0
	BEQ.S	GOING_DOWN
	CMP.B	#$4B,D0
	BEQ.S	GOING_LEFT
	CMP.B	#$4D,D0
	BEQ.S	GOING_RIGHT
EXIT_ROUTINE:
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$39,D0
	BEQ.S	.CHOSE_3D
	CMP.B	#$1,D0
	BEQ.S	.CHOSE_3D
	CMP.B	#$3B,D0
	BEQ.S	.CHOSE_2D
	CMP.B	#$3C,D0
	BEQ.S	.CHOSE_3D
	CMP.B	#$3D,D0
	BEQ.S	.CHOSE_MAP
	RTS

.CHOSE_2D:
	ADDQ.L	#4,A7
	BRA	DRAW_2D

.CHOSE_3D:
	ADDQ.L	#4,A7
	BRA	DRAW_REAL_3D

.CHOSE_MAP:
	ADDQ.L	#4,A7
	BRA	DRAW_COMPLETE_MAP

*****************************************************************
* THIS ROUTINE DEALS WITH ALL THE KEY INPUTS POSSIBLE IN THE    *
* EDITOR AND RESPONDS ACCORDINGLY.                              *
*****************************************************************

OPTION_ROUTINE:
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$3B,D0
	BEQ.S	.CHOSE_2D
	CMP.B	#$3C,D0
	BEQ.S	.CHOSE_3D
	CMP.B	#$3D,D0
	BEQ.S	.CHOSE_MAP
	CMP.B	#$3E,D0
	BEQ.S	.CHOSE_COLOR_EDITOR
	CMP.B	#$3F,D0
	BEQ.S	.CHOSE_RASTER_EDITOR
	CMP.B	#$40,D0
	BEQ.S	.CHOSE_GAME_PRESETS
	CMP.B	#$41,D0
	BEQ.S	.CHOSE_TO_SAVE_SMALL
	CMP.B	#$42,D0
	BEQ.S	.RETURN_TO_MAIN_MENU
	RTS

.CHOSE_2D:
	ADDQ.L	#4,A7
	BRA	DRAW_2D

.CHOSE_3D:
	ADDQ.L	#4,A7
	BRA	DRAW_REAL_3D

.CHOSE_MAP:
	ADDQ.L	#4,A7
	BRA	DRAW_COMPLETE_MAP

.CHOSE_COLOR_EDITOR:
	ADDQ.L	#4,A7
	BRA	RUN_COLOR_EDITOR

.CHOSE_RASTER_EDITOR:
	ADDQ.L	#4,A7
	BRA	RUN_RASTER_EDITOR

.CHOSE_TO_SAVE_SMALL:
	ADDQ.L	#4,A7
	BRA	RUN_SMALL_SAVE

.CHOSE_GAME_PRESETS:
	ADDQ.L	#4,A7
	BRA	DO_GAME_PRESETS

.RETURN_TO_MAIN_MENU:
	ADDQ.L	#4,A7
	BSR	COMPRESS_DATA
	ST	DATA_TO_DECOMPRESS
	BRA	MAIN_MENU

DATA_TO_DECOMPRESS:
	DC.W	0
 
CLEAR_SCREENS:
	LEA	SCREEN1,A0
	LEA	MEM+$80000,A1
	MOVEQ	#0,D0
.LOOP	MOVE.L	D0,(A0)+
	CMP.L	A1,A0
	BLT.S	.LOOP
	RTS

DRAW_ON_TEXT:
	LEA	TEXT,A0
	LEA	SCREEN1,A1
	LEA	SCREEN2,A2
	LEA	SCREEN3,A3
	MOVE.W	#2919,D0
.LOOP1:
	MOVE.L	(A0)+,D1
	MOVE.L	D1,(A1)+
	MOVE.L	D1,(A2)+
	MOVE.L	D1,(A3)+
	DBF	D0,.LOOP1
	RTS

DRAW_ON_MAIN_TEXT:
	LEA	MAIN_TEXT(PC),A0
	LEA	SCREEN1,A1
	BSR	DRAW_OUT_TEXT
	RTS

*****************************************************************************
* THIS IS WHERE ALL THE INTERRUPTS ARE KEPT!!
*****************************************************************************

KEY_VECTOR:				*THE NEW KEY VECTOR
	MOVE.L	A0,-(A7)
	MOVE.L 	D2,-(SP)
AND_AG:	MOVE.B 	$FFFFFC00.W,D2		
	BTST 	#7,D2			ANY CHARACTER WAITING?
	BEQ.S	.VECTOREND		NO THEN END
	MOVEQ	#0,D2
	MOVE.B 	$FFFFFC02.W,D2		READ CHARACTER INTO  'KBUFF'
	TST.B	MOUSE_SHIT
	BNE.S	.RUN_MOUSE
	CMP.B	#$F7,D2
	BEQ.S	.MOUSE
	LEA	KEY_BUFFER(PC),A0
	TST.B	D2			KEY PRESSED
	BPL.S	.SET_KEY
.CLR_KEY:
	BCLR	#7,D2			ELSE KEY DEPRESSED
	SF	(A0,D2.W)
	CLR.W	KBUFF
	BRA.S	.1
.SET_KEY:
	MOVE.B	D2,KBUFF
	ST	(A0,D2.W)
.1	BTST	#4,$FFFFFA01.W
	BEQ.S	AND_AG
.VECTOREND:
	MOVE.L 	(SP)+,D2
	MOVE.L	(SP)+,A0
	RTE
	
.MOUSE:	MOVE.L	#MOUSE_BUFFER,MOUSE_POINT
	ST	MOUSE_SHIT
	BRA.S	.1

.RUN_MOUSE:
	MOVE.L	MOUSE_POINT(PC),A0
	MOVE.B	D2,(A0)+
	MOVE.L	A0,MOUSE_POINT
	CMP.L	#KBUFF,A0
	BNE.S	.1
	CLR.B	MOUSE_SHIT
	BRA.S	.1
	
*********************
MOUSE_SHIT:	DC.B	0
MOUSE_BUFFER:
MOUSE_BUTTON:	DC.B	0
MOUSE_X:	DC.W	0
MOUSE_Y:	DC.W	0
KBUFF:		DC.W	0
MOUSE_POINT:	DC.W	0
*********************

KEY_BUFFER	DS.B	128

*****************************************************************************
* THE FIRST OF PROBABLY MANY VBLS!
*****************************************************************************

MAIN_VBL:				*VBL TO SHOW JUST CONTROL PANEL
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT
	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#220,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVEM.L	TEXT_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS

	IFNE	GENST
	CMP.B	#$39,KBUFF		ESC FOR QUIT
	BEQ	QUIT
	ENDC
	RTE

BLACK_VBL:				*VBL TO SHOW JUST CONTROL PANEL
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT
	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#60,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#BLACK_OUT_A,$120.W
	MOVEM.L	TEXT_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS

	IFNE	GENST
	CMP.B	#$39,KBUFF		ESC FOR QUIT
	BEQ	QUIT
	ENDC
	RTE

BLACK_OUT_A:
	MOVEM.L	A0-A1,-(A7)
	LEA	PALETTE,A0
	LEA	$FFFF8240.W,A1
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	CLR.B	$FFFFFA1B.W
	MOVE.B	#13,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#BLACK_OUT_B,$120.W
	MOVEM.L	(A7)+,A0-A1
	RTE

BLACK_OUT_B:
	MOVEM.L	D0/A1,-(A7)		TIMER B TO BLACK OUT SCREEN
	LEA	$FFFF8240.W,A1
	MOVEQ	#0,D0
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	MOVE.L	D0,(A1)+	
	CLR.B	$FFFFFA1B.W
	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVEM.L	(A7)+,D0/A1
	RTE

**********************BLACKOUT TIMERS******************************

DISK_VBL:				*VBL TO SHOW JUST CONTROL PANEL
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT
	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#DISK_A,$120.W
	MOVE.L	#$7770777,D0
	LEA	$FFFF8240.W,A0
	REPT	8
	MOVE.L	D0,(A0)+
	ENDR
	MOVE.W	#$0,$FFFF8240.W
	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS
	RTE

DISK_A:
	RTE

**********************************************
* TIMER ROUTINES FOR 3D DRAWING OF LANDSCAPE *
**********************************************
                
REAL_3D_VBL:
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT

	MOVE.L	PHYS_WATER(PC),A0
	MOVE.B	(A0)+,D0
	MOVE.B	(A0)+,D1
	SUB.B	D0,D1
	SUB.W	#73,D0
	SUB.B	#60,D0
	MOVE.B	D0,MARK2+3
	MOVE.B	D1,MARK1+3

	MOVE.W	PALETTE+2(PC),RASTER1+2

	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#62,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#FIRST_TIMERB,$120.W	PUT IN TIMER B VECTOR

	MOVEM.L	ED_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS

	IFNE	GENST
	CMP.B	#$39,KBUFF		ESC FOR QUIT
	BEQ	QUIT
	ENDC
	RTE

VBL_COUNT:	DC.W	0			*USED FOR VSYNC

FIRST_TIMERB:
	MOVEM.L	A0-A1,-(A7)
	LEA	PALETTE,A0
	LEA	$FFFF8240.W,A1
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	CLR.B	$FFFFFA1B.W
	MOVE.B	#11,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#SECOND_TIMERB,$120.W
	MOVEM.L	(A7)+,A0-A1
	RTE

SECOND_TIMERB:
	MOVE.W	#$0,$FFFF8242.W
	CLR.B	$FFFFFA1B.W
MARK2:	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.B	#1,$FFFFFA21.W
	MOVE.L	#SKY_COLORS,$120.W
	MOVE.L	#RASTERS,RASTER_POINT
	RTE

SKY_COLORS:
	MOVE.L	A0,-(A7)
	MOVE.L	RASTER_POINT(PC),A0
	MOVE.W	(A0)+,$FFFF8242.W
	CMP.L	#RASTERS+120,A0
	BEQ.S	.NEXT_TIMER	
	MOVE.L	A0,RASTER_POINT
	MOVE.L	(A7)+,A0
	RTE
.NEXT_TIMER:
	MOVE.L	(A7)+,A0
	MOVE.L	#TIMERB_1,$120.W
	RTE

RASTER_POINT:	DC.L	0

TIMERB_1:
RASTER1:
	MOVE.W	#$003,$FFFF8242.W
	CLR.B	$FFFFFA1B.W
MARK1:	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#TIMERB_2,$120.W
	RTE

TIMERB_2:
	MOVE.W	#$0,$FFFF8242.W
	CLR.B	$FFFFFA1B.W
	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	RTE

WATER_DATA1:	DC.B	100,102
WATER_DATA2:	DC.B	100,102
WATER_DATA3:	DC.B	100,102

PHYS_WATER:	DC.L	WATER_DATA1
LOG_WATER:	DC.L	WATER_DATA2

**********************************************
* TIMER ROUTINES FOR 2D DRAWING OF LANDSCAPE *
**********************************************
                
REAL_2D_VBL:
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT

	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#62,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#TIMER_2D,$120.W	PUT IN TIMER B VECTOR

	MOVEM.L	ED_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS

	IFNE	GENST
	CMP.B	#$39,KBUFF		ESC FOR QUIT
	BEQ.S	QUIT
	ENDC
	RTE

TIMER_2D:
	MOVEM.L	A0-A1,-(A7)
	LEA	PALETTE,A0
	LEA	$FFFF8240.W,A1
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	MOVE.L	(A0)+,(A1)+	
	CLR.B	$FFFFFA1B.W
	MOVE.B	#200,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVEM.L	(A7)+,A0-A1
	RTE

**********************************************
* TIMER ROUTINES FOR COMPLETE MAP SCREEN     *
**********************************************
                
MAP_VBL:
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)		PRESERVE REGISTERS
	ADDQ.W	#1,VBL_COUNT

	CLR.B	$FFFFFA1B.W		SET UP TIMERB
	MOVE.B	#220,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W

	MOVEM.L	PALETTE(PC),D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVEM.L	(A7)+,D0-A6		REPLACE REGISTERS

	IFNE	GENST
	CMP.B	#$39,KBUFF		ESC FOR QUIT
	BEQ.S	QUIT
	ENDC
	RTE


*************************NO MORE INTERRUPTS!*********************************

QUIT:
	MOVE.W 	#$2700,SR		TURN OFF INTS
	ADDQ.L	#6,A7
	BSR 	HBLOFF			RESET VALUES
	LEA 	$FFFF8800.W,A1		BLANK SOUNDCHIP
	MOVE.L 	#$8080000,(A1)
	MOVE.L 	#$9090000,(A1)
	MOVE.L 	#$A0A0000,(A1)
	MOVE.W 	#$2300,SR		TURN BACK ON INTS
	LEA	KEYBOARD_OFF(PC),A0
	BSR 	IKBD	
	MOVEM.L	OLD_PALETTE,D0-D7	PUT BACK OLD PALETTE
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVE.W	#1,-(SP)		SWITCH BACK TO MEDIUM RES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	MOVE.L	OLDSSP,-(A7)		RESTORE STACK
	MOVE.W	#$20,-(SP)		AND PUT BACK INTO USER MODE
	TRAP	#1
	ADDQ.L	#6,SP

	IFNE	GENST
	ILLEGAL				GOODBYE CRUEL WORLD!!
	ELSEIF
	CLR.W	-(SP)
	TRAP	#1
	ENDC

******************************************************************************
* ROUTINE FOR SETTING UP OF GENERAL INTERRUPTS
******************************************************************************

HBL_ON:
	MOVE.L 	$120.W,OLD_TB		SAVE INTERRUPTS
	MOVE.L 	$70.W,OLD_VBL
	MOVE.L 	$118.W,OLD_KEY
	MOVE.B 	$FFFFFA07.W,OLD_07
	MOVE.B 	$FFFFFA09.W,OLD_09
	MOVE.B 	$FFFFFA0F.W,OLD_0F
	MOVE.B 	$FFFFFA13.W,OLD_13
	MOVE.B 	$FFFFFA1B.W,OLD_1B
	MOVE.B	$FFFFFA17.W,OLD_17
	MOVE.L	$8.W,OLD_8
	MOVE.L	$C.W,OLD_C
	MOVE.L	$10.W,OLD_10
	MOVE.L	$20.W,OLD_20
	AND.B 	#$DF,$FFFFFA09.W	THEN SET UP OURS
	AND.B 	#$FE,$FFFFFA07.W
	MOVE.L 	#TIMERB_1,$120.W	FIRST TIMER B
	MOVE.L 	#BLACK_VBL,$70.W		FIRST VBL
	OR.B 	#1,$FFFFFA07.W
	OR.B 	#1,$FFFFFA13.W
	BSR.S	FLUSH
	BCLR 	#6,$FFFFFA09.W		PUT IN OUR NEW 
	MOVE.L 	#KEY_VECTOR,$118.W	KEY VECTOR
	BSET 	#6,$FFFFFA09.W
	BCLR	#3,$FFFFFA17.W
	LEA	ERROR_VEC(PC),A0
	MOVE.L	A0,$8.W
	MOVE.L	A0,$C.W
	MOVE.L	A0,$10.W
	MOVE.L	A0,$20.W
	MOVE.W	#$2300,SR
	RTS

FLUSH:	BTST.B	#0,$FFFFFC00.W
	BEQ.S	.1
	MOVE.B	$FFFFFC02.W,D0
	BRA.S	FLUSH
.1	RTS

ERROR_VEC:
	MOVE.W	#$2700,SR
	MOVE.L	#200000,D0
.LOOP	ADDQ.W	#1,$FFFF8240.W
	SUBQ.L	#1,D0
	BNE.S	.LOOP
	JMP	QUIT

**************************************************************************
* RESTORE ALL THE PREVIOUSLY STORED INTERRUPTS
**************************************************************************

HBLOFF:	MOVE.W 	SR,-(SP)		TAKE OUT ALL OF OUR INTS
	MOVE.W 	#$2700,SR
	MOVE.B 	OLD_07,$FFFFFA07.W
	MOVE.B 	OLD_09,$FFFFFA09.W
	MOVE.B 	OLD_0F,$FFFFFA0F.W
	MOVE.B 	OLD_13,$FFFFFA13.W
	MOVE.B 	OLD_1B,$FFFFFA1B.W
	MOVE.B	OLD_17,$FFFFFA17.W
	MOVE.L	OLD_8,$8.W
	MOVE.L	OLD_C,$C.W
	MOVE.L	OLD_10,$10.W
	MOVE.L	OLD_20,$20.W
	MOVE.L 	OLD_TB,$120.W
	MOVE.L 	OLD_VBL,$70.W
	MOVE.L 	OLD_KEY,$118.W
	MOVE.L 	OLD_PHYS,$FFFF8200.W
	BSET	#5,$FFFFFA09.W
	MOVE.W 	(SP)+,SR
	RTS

OLD_8:	DC.L	0
OLD_C:	DC.L	0
OLD_10:	DC.L	0
OLD_20:	DC.L	0

**************************************************************************
* WRITE DATA TO KEYBOARD PROCESSOR. ENTER WITH VALUE IN TO BE SENT IN D0
**************************************************************************

IKBD:	LEA 	$FFFFFC00.W,A1		WRITE TO THE KEYBOARD
	MOVEQ	#0,D7
	MOVE.B	(A0)+,D7
IKLOOP:	MOVE.B 	(A1),D1			PROCESSOR
	BTST 	#1,D1			READY TO RECIEVE DATA?
	BEQ.S 	IKLOOP
	MOVE.B 	(A0)+,2(A1)		SEND DATA
	DBF	D7,IKLOOP
	RTS

KEYBOARD_ON:	DC.B	6-1
		DC.B	$1A,$9,$0,$F8,$0,$C8
		EVEN

KEYBOARD_OFF:	DC.B	2-1
		DC.B	$14,$8
		EVEN

GET_ABSOLUTE:	DC.B	1-1
		DC.B	$D
		EVEN

SET_ABSOLUTE:	DC.B	6-1
		DC.B	$E,$0,$0,$A0,$0,$A0
		EVEN

**********************************************************
* THE FRACTAL FLIGHT CONTROL ROUTINES                    *
**********************************************************
	
READ_JOYSTICK:
	LEA	X_OFFSET(PC),A0
	MOVEQ	#0,D0
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$4D,D0
	BNE.S	.NOT_RIGHT
	ADDQ.W	#1,(A0)
	CMP.W	#19,(A0)
	BLT.S	.NOT_RIGHT
	MOVE.W	#18,(A0)
.NOT_RIGHT:
	CMP.B	#$4B,D0
	BNE.S	.NOT_LEFT
	SUBQ.W	#1,(A0)
	BPL.S	.NOT_LEFT
	MOVE.W	#0,(A0)
.NOT_LEFT:
	MOVE.W	#200,2(A0)

	MOVE.L	CLEAR_BUFFER_POINT(PC),A1	STORE THE Y_OFFSET FOR ERASING ON NEXT PASS THROUGH LOGBASE
	MOVE.W	2(A0),(A1)+
	CMP.L	#CLEAR_BUFFER_END,A1
	BNE.S	.1
	LEA	CLEAR_BUFFER(PC),A1
.1	MOVE.L	A1,CLEAR_BUFFER_POINT

	LEA	SPEED_CONSTANT(PC),A0
	CMP.B	#$48,KBUFF
	BEQ.S	.FORWARD
	CMP.B	#$50,KBUFF
	BEQ.S	.BACKWARD
	MOVE.W	#0,(A0)
.IN_RANGE:
	MOVE.W	(A0),D0
	SUB.W	D0,CURRENT_POS
	BMI.S	.TOP_OF_MAP
	CMP.W	#498,CURRENT_POS
	BGT.S	.BOTTOM
	RTS
.TOP_OF_MAP:
	MOVE.W	#0,CURRENT_POS
	RTS
.BOTTOM:
	MOVE.W	#498,CURRENT_POS
	RTS
.FORWARD:
	MOVE.W	#1,(A0)
	BRA.S	.IN_RANGE
.BACKWARD:
	MOVE.W	#-1,(A0)
	BRA.S	.IN_RANGE

SPEED_CONSTANT:	DC.W	0,0

CLEAR_BUFFER_POINT:	DC.L	CLEAR_BUFFER

CLEAR_BUFFER:	DC.W	180,180,180
CLEAR_BUFFER_END:

**********************************************************
* THE 2D MAP EDITOR CONTROLS                             *
**********************************************************
	
READ_JOYSTICK_FOR_MAP:
	LEA	GET_ABSOLUTE(PC),A0
	BSR	IKBD

	LEA	SPEED_CONSTANT(PC),A0
	BSR	.MOVE_TESTS

.RETURN_TO_KEY_BIT
	LEA	SPEED_CONSTANT(PC),A0
	MOVEQ	#0,D0
	MOVE.B	KBUFF(PC),D0
	TST.W	D0
	BEQ.S	.NICHTS
	CMP.B	#$0E,D0
	BLE	.SET_A_COLOR
	CMP.B	#$29,D0
	BEQ	.SET_A_COLOR
	CMP.B	#$63,D0
	BEQ	.SET_A_COLOR
	CMP.B	#$64,D0
	BEQ	.SET_A_COLOR
	CMP.B	#$16,D0
	BLE	.SET_A_HEIGHT
	CMP.B	#$2E,D0
	BEQ	.DO_A_COLUMN
	CMP.B	#$19,D0
	BEQ	.DO_AN_OBJECT
	CMP.B	#$4E,D0
	BEQ	.INC_OBJECT
	CMP.B	#$4A,D0
	BEQ	.DEC_OBJECT
	CMP.B	#$1F,D0
	BEQ	.SET_START
	CMP.B	#$61,D0
	BEQ	.UNDO
	CMP.B	#$66,D0
	BEQ	.CLEAR_ALL
.NICHTS	
	RTS

.IN_RANGE:
	MOVE.W	(A0),D0
	SUB.W	D0,CURRENT_POS
	BMI.S	.TOP_OF_MAP
	CMP.W	#498,CURRENT_POS
	BGT.S	.BOTTOM
	RTS
.TOP_OF_MAP:
	MOVE.W	#0,CURRENT_POS
	RTS
.BOTTOM:
	MOVE.W	#498,CURRENT_POS
	RTS

.MOVE_TESTS:
	MOVE.W	MOUSE_Y(PC),ICON_Y
	MOVE.W	MOUSE_X(PC),ICON_X
	CMP.W	#80,ICON_Y
	BLE.S	.SCROLL_MAP_UP
	MOVE.W	#0,(A0)
	CMP.W	#80+112,ICON_Y
	BGE.S	.SCROLL_MAP_DOWN
	MOVE.W	#0,(A0)
	BRA.S	.IN_RANGE
.SCROLL_MAP_DOWN:
	MOVE.W	#-1,(A0)
	MOVE.W	#80+112,ICON_Y
	BRA.S	.IN_RANGE
.SCROLL_MAP_UP:
	MOVE.W	#80,ICON_Y
	MOVE.W	#1,(A0)
	BRA.S	.IN_RANGE

.SET_A_COLOR:
	CMP.B	#$E,D0
	BNE.S	.NOT_E
	MOVE.B	#$F,D0
.NOT_E	CMP.B	#$29,D0
	BNE.S	.NOT_15
	MOVE.B	#$E,D0
.NOT_15:
	CMP.B	#$63,D0
	BNE.S	.NOT_LB
	MOVE.B	#$10,D0
.NOT_LB
	CMP.B	#$64,D0
	BNE.S	.NOT_RB
	MOVE.B	#$11,D0
.NOT_RB

	SUBQ.W	#1,D0

	TST.B	KEY_BUFFER+$23
	BNE	.LINE_OF_COLOR
	TST.B	KEY_BUFFER+$2F
	BNE	.V_LINE_OF_COLOR
	TST.B	KEY_BUFFER+$21
	BNE	.FILL_AREA

	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	ADD.L	D1,A1	
	MOVE.B	D0,(A1)
	RTS

.SET_A_HEIGHT:
	TST.B	KEY_BUFFER+$23
	BNE	.LINE_OF_HEIGHT
	TST.B	KEY_BUFFER+$2F
	BNE	.V_LINE_OF_HEIGHT
	
	LEA	HEIGHT_VALUES(PC),A1
	SUB.W	#15,D0
	MOVE.W	D0,D7
	ADD.W	D7,D7
	MOVE.W	(A1,D7.W),D7

	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	ADD.L	D1,A1	
	TST.W	D0
	BNE.S	.NO_COL
	MOVE.B	#0,(A1)
.NO_COL:
	LEA	MAP_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVEQ	#0,D2	
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	ADD.W	D2,D1
	MULU	#66,D1
	ADD.L	D1,A1

	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	LSL.W	#1,D1
	ADD.L	D1,A1	
	MOVE.W	D7,(A1)
	MOVE.W	D7,2(A1)
	MOVE.W	D7,66(A1)
	MOVE.W	D7,68(A1)

	RTS

.LINE_OF_COLOR:
	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVE.W	#31,D1
.LOOP_COLOR:
	MOVE.B	D0,(A1)+
	DBF	D1,.LOOP_COLOR
	RTS

.LINE_OF_HEIGHT:
	LEA	HEIGHT_VALUES(PC),A1
	SUB.W	#15,D0
	MOVE.W	D0,D7
	ADD.W	D7,D7
	MOVE.W	(A1,D7.W),D7

	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVEQ	#6,D0	
	MOVE.W	#31,D1
.LOOP_X
	MOVE.B	D0,(A1)+
	DBF	D1,.LOOP_X

	LEA	MAP_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVEQ	#0,D2	
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	ADD.W	D2,D1
	MULU	#66,D1
	ADD.L	D1,A1

	MOVEQ	#31,D1
.LOOP_Y
	MOVE.W	D7,(A1)
	MOVE.W	D7,2(A1)
	MOVE.W	D7,66(A1)
	MOVE.W	D7,68(A1)
	ADDQ.L	#2,A1
	DBF	D1,.LOOP_Y
	RTS

.DO_A_COLUMN:				*MAKES A SPIRE!
	CLR.W	KBUFF
.LOOP3	TST.W	KBUFF
	BEQ.S	.LOOP3
	MOVEQ	#0,D0
	MOVE.B	KBUFF(PC),D0	
	CMP.B	#$E,D0
	BLE.S	.NOT_THIS_TIME
	CMP.B	#$16,D0
	BLE.S	.COLUMN_OF_HEIGHT
.NOT_THIS_TIME
	RTS
	
.COLUMN_OF_HEIGHT:
	LEA	HEIGHT_VALUES(PC),A1
	SUB.W	#15,D0
	MOVE.W	D0,D7
	ADD.W	D7,D7
	MOVE.W	(A1,D7.W),D7

	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	ADD.L	D1,A1
	MOVEQ	#6,D0	
	MOVE.B	D0,(A1)
	MOVE.B	D0,-33(A1)
	MOVE.B	D0,-32(A1)
	MOVE.B	D0,-1(A1)

	LEA	MAP_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVEQ	#0,D2	
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	ADD.W	D2,D1
	MULU	#66,D1
	ADD.L	D1,A1

	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	LSL.W	#1,D1
	ADD.L	D1,A1	
	MOVE.W	D7,(A1)
	CLR.W	KBUFF
	RTS

.SET_START
	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	LSR.W	#3,D2
	ADD.L	D2,D1
	MOVE.W	D1,SHIP_START_Z
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	LSR.W	#3,D1
	MOVE.W	D1,SHIP_START_X
	RTS

.DO_AN_OBJECT:
	LEA	OBJECT_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	ADD.L	D1,A1	
	MOVE.B	CURRENT_OBJECT(PC),(A1)			ADD OBJECT TO LANDSCAPE
	RTS

.INC_OBJECT:
	CMP.B	#NUMBER_OF_OBJECTS,CURRENT_OBJECT
	BEQ.S	.INC_END
	ADDQ.B	#1,CURRENT_OBJECT
.INC_END:
	CLR.W	KBUFF
	RTS

.DEC_OBJECT:
	TST.B	CURRENT_OBJECT
	BEQ.S	.DEC_END
	SUBQ.B	#1,CURRENT_OBJECT
.DEC_END:
	CLR.W	KBUFF
	RTS

***THIS LITLE ROUT DOES A LINE OF HEIGHT AND COLOR***

.UNDO
	LEA	COLOR_ARRAY,A1
	LEA	RESERVE_COLOR_ARRAY,A2
	LEA	OBJECT_ARRAY,A3
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	LSL.L	#5,D1
	ADD.L	D1,A1
	ADD.L	D1,A2
	ADD.L	D1,A3
	MOVEQ	#0,D1	
	MOVE.W	ICON_Y(PC),D1
	SUB.W	#80,D1
	AND.L	#%1111111111111000,D1
	LSL.W	#2,D1
	ADD.L	D1,A1
	ADD.L	D1,A2
	ADD.L	D1,A3
	
	MOVE.W	#31,D1
.LOOP_X1
	MOVE.B	(A2)+,(A1)+
	CLR.B	(A3)+
	DBF	D1,.LOOP_X1

	LEA	MAP_ARRAY,A1
	LEA	RESERVE_MAP_ARRAY,A2
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVEQ	#0,D2	
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	ADD.W	D2,D1
	MULU	#66,D1
	ADD.L	D1,A1
	ADD.L	D1,A2

	MOVEQ	#31,D1
.LOOP_Y1
	MOVE.W	(A2),(A1)
	MOVE.W	2(A2),2(A1)
	MOVE.W	66(A2),66(A1)
	MOVE.W	68(A2),68(A1)
	ADDQ.L	#2,A2
	ADDQ.L	#2,A1
	DBF	D1,.LOOP_Y1
	RTS

.V_LINE_OF_COLOR:
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	LEA	COLOR_ARRAY,A1
	ADD.W	D1,A1
	MOVE.W	#511,D1
.LOOP_COLORB:
	MOVE.B	D0,(A1)
	LEA	32(A1),A1
	DBF	D1,.LOOP_COLORB
	RTS

.V_LINE_OF_HEIGHT:
	LEA	HEIGHT_VALUES(PC),A1
	SUB.W	#15,D0
	MOVE.W	D0,D7
	ADD.W	D7,D7
	MOVE.W	(A1,D7.W),D7

	LEA	COLOR_ARRAY,A1
	MOVEQ	#0,D1
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#3,D1
	ADD.W	D1,A1
	
	MOVE.W	#511,D1
	MOVEQ	#6,D0
.LOOP_X2
	MOVE.B	D0,(A1)
	LEA	32(A1),A1
	DBF	D1,.LOOP_X2

	LEA	MAP_ARRAY,A1
	MOVEQ	#0,D1	
	MOVE.W	ICON_X(PC),D1
	AND.W	#%1111111111111000,D1
	LSR.W	#2,D1
	ADD.L	D1,A1

	MOVE.W	#511,D1
.LOOP_Y2
	MOVE.W	D7,(A1)
	MOVE.W	D7,2(A1)
	MOVE.W	D7,66(A1)
	MOVE.W	D7,68(A1)
	LEA	66(A1),A1
	DBF	D1,.LOOP_Y2
	RTS

.CLEAR_ALL:
	CLR.W	KBUFF
.WAIT:	TST.W	KBUFF
	BEQ.S	.WAIT
	CMP.B	#$66,KBUFF
	BNE.S	.NOT_CLEAR_ALL
	LEA	RESERVE_MAP_ARRAY,A0
	LEA	MAP_ARRAY,A1
	MOVE.W	#(50274/2)-1,D0
.LOOPR	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOPR
.NOT_CLEAR_ALL:
	RTS

.FILL_AREA:
	CLR.B	KEY_BUFFER+$21
	MOVEM.L	D0-A6,-(A7)
	MOVEQ	#0,D1
	MOVE.W	CURRENT_POS(PC),D1
	MOVE.W	ICON_Y(PC),D2
	SUB.W	#80,D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	ADD.L	D2,D1
 	MOVE.W	ICON_X(PC),D2
	AND.W	#%1111111111111000,D2
	LSR.W	#3,D2
	MOVE.W	D2,FILL_X
	MOVE.W	D1,FILL_Y
	
	LSL.W	#5,D1
	ADD.W	D2,D1	
	
	LEA	COLOR_ARRAY,A1
	LEA	DATA_BUFFER,A2		WORK STACK
	MOVE.B	(A1,D1.W),D1

	CMP.B	D0,D1
	BEQ	.END_FILL

* D0 = FILL COLOR, D1 = TARGET COLOR

	MOVE.L	A2,A3
	MOVE.W	FILL_X(PC),(A3)+
	MOVE.W	FILL_Y(PC),(A3)+
	MOVE.W	#-1,(A3)
.FILL_LOOP:
	CMP.W	#-1,(A2)
	BEQ	.END_FILL
	MOVE.W	(A2)+,D2
	MOVE.W	(A2)+,D3
	MOVE.W	D2,D4
	MOVE.W	D3,D5
	LSL.W	#5,D3
	ADD.W	D2,D3
	LEA	(A1,D3.W),A4
	MOVE.B	D0,(A4)

	TST.W	D4
	BEQ.S	.N1
	CMP.B	-1(A4),D1
	BNE.S	.N1
	MOVE.W	D4,D6
	MOVE.W	D5,D7
	SUBQ.W	#1,D6
	MOVE.W	D6,(A3)+
	MOVE.W	D7,(A3)+
	LSL.W	#5,D7
	ADD.W	D6,D7
	MOVE.B	D0,(A1,D7.W)

.N1
	CMP.W	#31,D4
	BEQ.S	.N2

	CMP.B	1(A4),D1
	BNE.S	.N2
	MOVE.W	D4,D6
	MOVE.W	D5,D7
	ADDQ.W	#1,D6
	MOVE.W	D6,(A3)+
	MOVE.W	D7,(A3)+
	LSL.W	#5,D7
	ADD.W	D6,D7
	MOVE.B	D0,(A1,D7.W)

.N2
	TST.W	D5
	BEQ.S	.N3
	CMP.B	-32(A4),D1
	BNE.S	.N3
	MOVE.W	D4,D6
	MOVE.W	D5,D7
	SUBQ.W	#1,D7
	MOVE.W	D6,(A3)+
	MOVE.W	D7,(A3)+
	LSL.W	#5,D7
	ADD.W	D6,D7
	MOVE.B	D0,(A1,D7.W)

.N3
	CMP.W	#32*16,D5
	BEQ.S	.N4
	CMP.B	32(A4),D1
	BNE.S	.N4
	MOVE.W	D4,D6
	MOVE.W	D5,D7
	ADDQ.W	#1,D7
	MOVE.W	D6,(A3)+
	MOVE.W	D7,(A3)+
	LSL.W	#5,D7
	ADD.W	D6,D7
	MOVE.B	D0,(A1,D7.W)
.N4
	MOVE.W	#-1,(A3)
	BRA	.FILL_LOOP
.END_FILL:
	MOVEM.L	(A7)+,D0-A6
	RTS

FILL_X:	DC.W	0
FILL_Y:	DC.W	0

HEIGHT_VALUES:
	DC.W	0,-38,-76,-114,-152,-190,-228,-266,0,0,0

CURRENT_OBJECT:	DC.B	1,0

**********************************************************
* HERE FOLLOW ALL THE ROUTINES PERTAINING TO THE FRACTAL *
* CALCULATION.					         *
**********************************************************

CLEAN_ARRAY_A:
	LEA	MAP_ARRAY,A0		*THIS FILLS THE ENTIRE MAP
	MOVE.W	LAND_LEVEL(PC),D0	*TO THE INITIAL LAND LEVEL
.LOOP:	MOVE.W	D0,(A0)+
	CMP.L	#MAP_ARRAY_END,A0
	BNE.S	.LOOP
	LEA	OBJECT_ARRAY,A0
	LEA	OBJECT_ARRAY_END,A1
	MOVEQ	#0,D0
.LOOP1	MOVE.W	D0,(A0)+
	CMP.L	A1,A0
	BLT.S	.LOOP1
	RTS

CLEAN_ARRAY_B
	MOVE.W	WATER_LEVEL,D1
	SUB.W	#10,D1

	MOVEQ	#GRID_SIZE,D0			THIS ENSURES THAT THE TOP AND 
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY+((GRID_SIZE*16)*((GRID_SIZE+1)*2))),A3
.LOOP1:	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A3)+
	DBF	D0,.LOOP1

	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS
	MOVE.W	LAND_LEVEL(PC),D1
	ADD.L	#1500,D1
.MISS:
	MOVE.W	#GRID_SIZE*16,D0		THIS MAKES LEFT AND RIGHT EDGE
	LEA	MAP_ARRAY,A1			ABOVE SEA LEVEL
	LEA	MAP_ARRAY+(GRID_SIZE*2),A2
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS1
	LEA	MAP_ARRAY+GRID_SIZE,A3		AND PUTS A VALEEY IN IF NEEDED
	MOVE.W	RIVER_HEIGHT(PC),D2
.MISS1:
.LOOP2:
	MOVE.W	D1,(A1)			
	MOVE.W	D1,(A2)
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS2
	MOVE.W	D2,(A3)
	LEA	(GRID_SIZE+1)*2(A3),A3
.MISS2
	LEA	(GRID_SIZE+1)*2(A1),A1
	LEA	(GRID_SIZE+1)*2(A2),A2
	DBF	D0,.LOOP2
.NO_MORE_NEEDED:
	RTS


CLEAN_COLOR_ARRAY_THINGY:
	LEA	COLOR_ARRAY,A0		*THIS FILLS THE ENTIRE MAP
	MOVE.W	LAND_LEVEL(PC),D0	*TO THE INITIAL LAND LEVEL
.LOOP:	MOVE.W	D0,(A0)+
	CMP.L	#COLOR_ARRAY+((GRID_SIZE+1)*(GRID_SIZE+1)*2),A0
	BNE.S	.LOOP

	MOVEQ	#GRID_SIZE,D0			THIS ENSURES THAT THE TOP AND 
	MOVE.W	WATER_LEVEL(PC),D1		BOTTOM EDGES ARE AT SEA LEVEL
	LEA	COLOR_ARRAY,A0
	LEA	COLOR_ARRAY+(GRID_SIZE*((GRID_SIZE+1)*2))),A3
.LOOP1:	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A3)+
	DBF	D0,.LOOP1

	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS
	MOVE.W	LAND_LEVEL(PC),D1
	ADD.L	#1500,D1
.MISS:
	MOVEQ	#GRID_SIZE,D0			THIS MAKES LEFT AND RIGHT EDGE
	LEA	COLOR_ARRAY,A1			ABOVE SEA LEVEL
	LEA	COLOR_ARRAY+(GRID_SIZE*2),A2
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS1
	LEA	COLOR_ARRAY+GRID_SIZE,A3		AND PUTS A VALLEY IN IF NEEDED
	MOVE.W	RIVER_HEIGHT(PC),D2
.MISS1:
.LOOP2:
	MOVE.W	D1,(A1)			
	MOVE.W	D1,(A2)
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS2
	MOVE.W	D2,(A3)
	LEA	(GRID_SIZE+1)*2(A3),A3
.MISS2
	LEA	(GRID_SIZE+1)*2(A1),A1
	LEA	(GRID_SIZE+1)*2(A2),A2
	DBF	D0,.LOOP2
	RTS

DEVIATION:	DC.W	0

CALC_PLAY_AREA:
	BSR	CLEAN_ARRAY_A

	MOVE.L	RANDOM_NUMBER(PC),RANDOM_NUMBER_COPY

	CMP.W	#2,CREATION_STYLE
	BEQ	.NO_MORE_NEEDED
	CMP.W	#4,CREATION_STYLE
	BEQ	.MAKE_TRENCH_BASIS

	BSR	CLEAN_COLOR_ARRAY_THINGY

	LEA	COLOR_ARRAY,A0			*FIRST MAKE INITIAL LINES
	BSR	CALC_ARRAY

	LEA	COLOR_ARRAY+(((GRID_SIZE+1)*2)*GRID_SIZE),A0
	LEA	MAP_ARRAY_END-((GRID_SIZE+1)*2),A1	
	MOVEQ	#GRID_SIZE,D0
.LOOP:
	MOVE.L	D0,-(A7)		*NOW COPY EACH LINE ONTO EVERY 
	MOVEM.L	(A0),D0-D7/A2-A6	*16TH LINE OF THE MAP ARRAY
	MOVEM.L	D0-D7/A2-A6,(A1)
	MOVEM.W	52(A0),D0-D6
	MOVEM.W	D0-D6,52(A1)
	LEA	-(GRID_SIZE+1)*2(A0),A0
	LEA	-((GRID_SIZE+1)*2)*16(A1),A1	
	MOVE.L	(A7)+,D0
	DBF	D0,.LOOP

	BSR	CLEAN_ARRAY_B

**************THIS LITTLE GEM MAKES A VERY DEEP CANNYON THROUGH************
**************ANY FRACTAL. SET UP USING CREATION STYLE IN MENU!************

	CMP.W	#3,CREATION_STYLE
	BNE	.NO_DEEP_CANYON
	MOVE.L	#GRID_SIZE*16,D7	THIS MAKES LEFT AND RIGHT EDGE
	LEA	MAP_ARRAY+GRID_SIZE,A3
	MOVE.W	WATER_LEVEL(PC),D2
.LOOP2:
	BSR	RANDOM
	AND.L	#$3,D0
	BEQ.S	.NO_CHANGE
	CMP.W	#1,D0
	BEQ.S	.NO_CHANGE
	CMP.W	#2,D0
	BEQ.S	.LEFT
	ADDQ.W	#2,DEVIATION
	BRA.S	.OVER
.LEFT	SUBQ.W	#2,DEVIATION
.OVER	CMP.W	#22,DEVIATION
	BLT.S	.OK
	MOVE.W	#20,DEVIATION
.OK	CMP.W	#-22,DEVIATION
	BGT.S	.NO_CHANGE
	MOVE.W	#-20,DEVIATION
.NO_CHANGE
	MOVE.W	DEVIATION(PC),D0
	LEA	(A3,D0.W),A4
	MOVE.W	D2,(A4)
	MOVE.W	D2,-2(A4)
	MOVE.W	D2,2(A4)
	MOVE.W	D2,-4(A4)
	MOVE.W	D2,4(A4)
	MOVE.W	D2,6(A4)
	MOVE.W	D2,-6(A4)
	LEA	(GRID_SIZE+1)*2(A3),A3
	DBF	D7,.LOOP2

.NO_DEEP_CANYON:
	MOVEQ	#(GRID_SIZE/2)-1,D0
	LEA	MAP_ARRAY,A0
.FINAL_MAKE_LOOP:
	MOVE.L	D0,-(A7)
	BSR	CALC_ARRAY
	MOVE.L	(A7)+,D0
	LEA	((GRID_SIZE+1)*2)*32(A0),A0
	DBF	D0,.FINAL_MAKE_LOOP

.NO_MORE_NEEDED:
	BSR	CONVERT_FORMAT

	RTS

.MAKE_TRENCH_BASIS:
	LEA	MAP_ARRAY,A0
	LEA	COLOR_ARRAY,A1
	MOVEQ	#5,D7
	MOVE.W	#512,D0
.LOOPT:	
	MOVE.W	#10,D1
.LOOP1C:
	MOVE.W	#-266,(A0)+
	DBF	D1,.LOOP1C
	MOVE.W	#10,D1
.LOOP2C:
	MOVE.W	#0,(A0)+
	DBF	D1,.LOOP2C
	MOVE.W	#10,D1
.LOOP3:	MOVE.W	#-266,(A0)+
	DBF	D1,.LOOP3
	MOVE.W	#9,D1
.LOOP1B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP1B
	MOVE.B	D7,(A1)+
	MOVE.W	#9,D1
.LOOP2B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP2B
	MOVE.B	D7,(A1)+
	MOVE.W	#9,D1
.LOOP3B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP3B
	CMP.W	#5,D7
	BEQ.S	.END1
	MOVEQ	#5,D7
	DBF	D0,.LOOPT
	RTS
.END1:	MOVEQ	#6,D7
	DBF	D0,.LOOPT
	RTS

****************************************************
*   PROCEDURE TO CALCULATE THE INITIAL GRID FOR    *
* THE GAME AREA (IE EVERY 32 LINE IS ASSIGNED VALS)*
****************************************************

CALC_ARRAY:
	LEA	GRID_MULT_TABLE,A5
	LEA	POINT_TABLE(PC),A6
	MOVEQ	#GRID_SIZE,D0		D0 = SIZE
	MOVE.W	RANDOM_FAC(PC),D1		D1 = RANDOM FACTOR
	LSR.W	#1,D0			
.LOOP:
	LSR.W	#1,D1
	MOVEQ	#0,D3			D3 = Y COORD = 0
.LOOP1:
	MOVEQ	#0,D2			D2 = X COORD = 0
.LOOP2:
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVE.W	D3,D4
	ADD.W	D4,D4			*TABLE MULTIPLICATION
	ADD.W	D4,D4			*
	MOVE.L	(A5,D4.L),D4		*
	MOVE.W	D2,D5
	ADD.W	D5,D5
	ADD.L	D4,D5
	MOVE.W	(A0,D5.L),D6
	CMP.W	LAND_LEVEL,D6
	BNE.S	.NO_CALC
	MOVEM.L	D0-D3/D7,-(SP)
	BSR.S	DO_CALC
	MOVEM.L	(SP)+,D0-D3/D7
.NO_CALC:
	ADD.W	D0,D2
	CMP.W	#GRID_SIZE,D2
	BLE.S	.LOOP2
	
	ADD.W	D0,D3
	CMP.W	#GRID_SIZE,D3
	BLE.S	.LOOP1		

	LSR.W	#1,D0
	BNE.S	.LOOP
	RTS

************************************************
* THIS ROUTINE DOES THAT ACTUAL CALCULATION OF *
* THE MAP ARRAY POINTS (IE THE FRACTAL)        *
************************************************

*	D0 = SIZE
*	D1 = RANDOM FACTOR
*	D2 = X
*  	D3 = Y

DO_CALC:
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	TST.W	D5
	BPL.S	.NEXT_OPT
******* POINT ON THE TOP BORDER *******
	MOVE.W	D2,D4			
	SUB.W	D0,D4			X1%
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	MOVEQ	#0,D5			Y1%
	MOVEQ	#0,D7			Y2%
	MOVEM.W	D4-D7,-(SP)		move x1,y1 & x2,y2 onto stack	
	MOVEM.W	D4-D7,-(SP)		move x3,y3 & x4,y4 onto stack
	BRA.S	CALC_IT
.NEXT_OPT:
	MOVE.W	D2,D4
	SUB.W	D0,D4
	TST.W	D4			X1%
	BPL.S	.NEXT_OPT1
******* ON THE LEFT BORDER *******
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	MOVEQ	#0,D4			X1%
	MOVEQ	#0,D6			X2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT1:
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	CMP.W	#GRID_SIZE,D7
	BLE.S	.NEXT_OPT2
******* ON THE LOWER BORDER *******
	MOVE.W	D2,D4
	SUB.W	D0,D4			X1%
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	MOVE.W	#GRID_SIZE,D5		Y1%
	MOVE.W	#GRID_SIZE,D7		Y2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT2:
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	CMP.W	#GRID_SIZE,D6
	BLE.S	.NEXT_OPT3
******* ON THE RIGHT BORDER *******
	MOVE.W	#GRID_SIZE,D4		X1%
	MOVE.W	#GRID_SIZE,D6		X2%
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT3
	MOVEM.W	D4-D7,-(SP)
	EXG	D4,D6
	MOVEM.W	D4-D7,-(SP)
CALC_IT:
	MOVEM.W	D0-D3,-(SP)
	MOVEM.W	(SP)+,A1-A4

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	12(A7),D0-D1		X2,Y2
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NEXT_OPT1
	MOVE.W	A3,D4			X1%
	MOVE.W	A3,D6			X2%
	MOVE.W	A4,D5
	SUB.W	A1,D5			Y1%
	MOVE.W	A4,D7
	ADD.W	A1,D7			Y2%
	MOVEM.W	D4-D7,(A7)
	MOVEM.W	D4-D7,8(A7)
.NEXT_OPT1:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	4(A7),D0-D1		X3,Y3
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NEXT_OPT2
	MOVE.W	A3,D4
	SUB.W	A1,D4			X1%
	MOVE.W	A3,D6
	ADD.W	A1,D6			X2%
	MOVE.W	A4,D5
	MOVE.W	A4,D7
	MOVEM.W	D4-D7,(A7)
	MOVEM.W	D4-D7,8(A7)
.NEXT_OPT2:

FINAL_CALC:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X1,Y1
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0	
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X2,Y2
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X3,Y3
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X4,Y4
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	LSR.W	#2,D2			/4

	BSR	RANDOM

	MOVE.W	A2,D1			*MAKE UP THE RANDOM NUMBER
	ADD.W	D1,D1			*ACCORDING TO THE 
	MULU	D1,D0			*CURRENT RANDOM FACTOR
	SWAP	D0			*
	SUB.W	A2,D0			*THIS ENSURES + & - NUMBERS

	ADD.W	D0,D2			*ADD THE RANDOM FACTOR
	BPL.S	.NOT_NEG

	MOVEQ	#0,D2
.NOT_NEG:
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NOT_INITIAL
	ADDQ.W	#1,D2
.NOT_INITIAL:
	CMP.W	#4096,D2
	BLT.S	.IN_RANGE
	MOVE.W	#4095,D2
.IN_RANGE

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.W	A3,D0
	MOVE.W	A4,D1
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	AND.W	#%0000111111111111,D2
	MOVE.W	D2,(A0,D1.L)
	RTS

****************************************************
* LITTLE ROUTINE TO DRAW OUT THE COMPLETE MAP ON   *
* THE CURRNET SCREEN                               *
****************************************************

SAVE_BUFFER:	DS.B	260

CALC_THE_MAP:
	LEA	COLOR_ARRAY,A0
	LEA	DATA_BUFFER,A3
	BSR	DRAW_ARRAY

	MOVE.W	CURRENT_POS(PC),D0
	LSL.L	#4,D0
	LEA	DATA_BUFFER,A0
	ADD.L	D0,A0
	LEA	SAVE_BUFFER(PC),A1
	MOVE.L	A0,(A1)+
	MOVE.W	#127,D0
.LOOP
	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOP
	RTS

DRAW_THE_MAP:
	LEA	SAVE_BUFFER(PC),A1	REPLACE_SQUARE
	MOVE.L	(A1)+,A0
	MOVE.W	#127,D0
.LOOP
	MOVE.W	(A1)+,(A0)+
	DBF	D0,.LOOP

	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS(PC),D0
	LSL.W	#4,D0
	LEA	DATA_BUFFER,A0
	ADD.L	D0,A0
	LEA	SAVE_BUFFER(PC),A1
	MOVE.L	A0,A2
	MOVE.L	A0,(A1)+
	MOVEQ	#127,D0
.LOOP2:
	MOVE.W	(A0)+,(A1)+	
	DBF	D0,.LOOP2				

	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+
	MOVE.W	#11,D0
.LOOP3
	OR.L	#%10000000000000001000000000000000,(A2)+
	OR.L	#%10000000000000001000000000000000,(A2)+
	OR.L	#%00000000000000010000000000000001,(A2)+	
	OR.L	#%00000000000000010000000000000001,(A2)+	
	DBF	D0,.LOOP3

	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+
	OR.L	#-1,(A2)+

	MOVE.L	LOGBASE(PC),A0
	ADDQ.W	#8,A0
	LEA	DATA_BUFFER,A1
	MOVE.W	#1,D0
.LOOPF:
	MOVE.W	#199,D1
.LOOP1
	MOVE.L	(A1)+,(A0)
	MOVE.L	(A1)+,4(A0)
	MOVE.L	(A1)+,8(A0)
	MOVE.L	(A1)+,12(A0)
	LEA	160(A0),A0
	DBF	D1,.LOOP1
	LEA	-31976(A0),A0
	DBF	D0,.LOOPF

	MOVE.W	#111,D1
.LOOP1S
	MOVE.L	(A1)+,(A0)
	MOVE.L	(A1)+,4(A0)
	MOVE.L	(A1)+,8(A0)
	MOVE.L	(A1)+,12(A0)
	LEA	160(A0),A0
	DBF	D1,.LOOP1S

	LEA	NUMBER_FONT(PC),A3
	MOVE.W	CURRENT_POS(PC),D0
	MOVE.L	LOGBASE(PC),A0
	ADD.L	#(30*160)+128,A0
	BSR	DRAW_4_DIGIT
	RTS

DRAW_ARRAY:
	LEA	COLOR_DATA(PC),A1
	LEA	.MARK1(PC),A2
	LEA	POINT_TABLE(PC),A6
	MOVEQ	#0,D5

	MOVE.L	#511,D7			*HOW MAY LINES TO BE DRAWN OUT	
.LOOP1:
	LEA	(A3,D5.W),A5
	MOVEQ	#0,D2
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVEQ	#GRID_SIZE-1,D6
.LOOP2:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	LSL.W	#3,D2
	LEA	(A1,D2.W),A5

	MOVE.L	(A5)+,(A2)		*MODIFY THE CODE
	MOVE.L	(A5)+,4(A2)

	MOVEQ	#0,D1
	MOVE.W	D6,D1			*GET DOT POSITION
	NEG.W	D1
	ADD.W	#31,D1
	MOVE.W	D1,D2			*AND ISOLATE POINT DATA
	AND.L	#$F,D2
	SUB.W	D2,D1
	LSR.W	#1,D1
	ADD.W	D2,D2
	ADD.L	D5,D1

	MOVE.W	(A6,D2.W),D0		*GET POINT DATA
	MOVE.W	D0,D2			
	NOT.W	D2			*AND MAKE MASK

	LEA	(A3,D1.L),A5		*GET SCREEN POSITION

.MARK1	OR.W	D0,(A5)+		*SELF MODIFYING CODE FOR
	OR.W	D0,(A5)+		*COLOR PLOT
	OR.W	D0,(A5)+
	AND.W	D2,(A5)+

	DBF	D6,.LOOP2
	ADD.W	#16,D5
	DBF	D7,.LOOP1
	RTS

ANDD:		EQU	$C25D
ORD:		EQU	$815D
	
COLOR_DATA:
	DC.W	ORD,ANDD,ANDD,ANDD
	DC.W	ANDD,ORD,ANDD,ANDD
	DC.W	ORD,ORD,ANDD,ANDD
	DC.W	ANDD,ANDD,ORD,ANDD
	DC.W	ORD,ANDD,ORD,ANDD
	DC.W	ANDD,ORD,ORD,ANDD
	DC.W	ORD,ORD,ORD,ANDD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ORD,ANDD,ANDD,ORD
	DC.W	ANDD,ORD,ANDD,ORD
	DC.W	ORD,ORD,ANDD,ORD
	DC.W	ANDD,ANDD,ORD,ORD
	DC.W	ORD,ANDD,ORD,ORD
	DC.W	ANDD,ORD,ORD,ORD
	DC.W	ORD,ORD,ORD,ORD
	DC.W	ANDD,ORD,ANDD,ANDD
	DC.W	ORD,ORD,ANDD,ANDD

RANDOM:
	MOVEM.W	RANDOM_NUMBER_COPY(PC),D0-D1
	ROR.W	#1,D0
	ADDQ.W	#7,D0
	EOR.W	D1,D0
	EXG	D0,D1
	MOVEM.W	D0-D1,RANDOM_NUMBER_COPY
	RTS

RANDOM_NUMBER_COPY:	DC.L	0

RANDOM2:
	MOVEM.L	D0-D1,-(A7)
	MOVEM.W	RANDOM_NUMBER(PC),D0-D1
	ROR.W	#1,D0
	ADDQ.W	#7,D0
	EOR.W	D1,D0
	EXG	D0,D1
	MOVEM.W	D0-D1,RANDOM_NUMBER
	MOVEM.L	(A7)+,D0-D1
	RTS

POINT_TABLE:
	DC.W	%1000000000000000
	DC.W	%0100000000000000
	DC.W	%0010000000000000
	DC.W	%0001000000000000
	DC.W	%0000100000000000
	DC.W	%0000010000000000
	DC.W	%0000001000000000
	DC.W	%0000000100000000
	DC.W	%0000000010000000
	DC.W	%0000000001000000
	DC.W	%0000000000100000
	DC.W	%0000000000010000
	DC.W	%0000000000001000
	DC.W	%0000000000000100
	DC.W	%0000000000000010
	DC.W	%0000000000000001

PREPARE_GRID_MULT:
	LEA	GRID_MULT_TABLE_END,A0
	MOVE.W	#GRID_SIZE*32,D0
.LOOP:
	MOVE.W	D0,D1
	MULU	#(GRID_SIZE+1)*2,D1
	MOVE.L	D1,-(A0)
	DBF	D0,.LOOP

	LEA	TAB_160,A0
	MOVEQ	#0,D0
	MOVE.W	#199,D1
.LOOP1:	MOVE.W	D0,D2
	MULU	#160,D2
	MOVE.W	D2,(A0)+
	ADDQ.W	#1,D0
	DBF	D1,.LOOP1

	RTS

PREPARE_PROJ_DIVU:
	LEA	PROJ_DIVU_TAB,A0
	MOVE.L	#(16777216*3)/2,D1
	MOVE.L	#16384,D2
	MOVE.L	#16383,D0
.LOOP
	MOVE.L	D2,D3
	SUB.L	D0,D3
	ADD.L	D3,D3
	MOVE.L	D1,D4
	DIVU	D3,D4
	MOVE.W	D4,(A0)+
	SUBQ.W	#1,D0
	CMP.W	#8192,D0
	BNE.S	.LOOP
	RTS

*********************************************
* PRE CALCULATES THE X AND Z DATA FOR THE   *
* 3 DIMENSIONAL DRAWING                     *
*********************************************

MAKE_PRE_CALC_TABLE:
	LEA	PROJ_DIVU_TAB,A1
	LEA	PRE_CALC_TABLE,A6
	LEA	PRE_CALC_PERS,A4
	MOVEQ	#39,D0
.LOOP
	MOVE.W	ROUGH_Z(PC),D1
	ADD.W	D1,D1
	LEA	(A1,D1.W),A5
	MOVE.W	(A5),D4

	MOVE.W	#-256,D1		*CREATE -256 TO +256 TABLES
.LOOPP:		
	MOVE.W	D1,D2			*THUS NO MULS ARE NEEDED FOR PERSPECTIVE
	MULS	D4,D2			*TRANSFORMATION
	SWAP	D2
	ADD.W	#125,D2
	MOVE.B	D2,(A4)+
	ADDQ.W	#1,D1
	CMP.W	#256,D1
	BNE.S	.LOOPP
	
	SUB.W	#34,ROUGH_Z
	MOVE.W	#-507,ROUGH_X
	MOVEQ	#13,D7
.LOOP2
	MOVE.W	ROUGH_X(PC),D6		THEN DO X OFFSET
	MOVE.W	D4,D5
	MULS	D5,D6
	SWAP	D6
	ADD.W	#160,D6			
	MOVE.W	D6,(A6)+		STORE X POINT
	ADD.W	#78,ROUGH_X
	DBF	D7,.LOOP2
	DBF	D0,.LOOP

	MOVE.W	ROUGH_Z(PC),D1		GET Z FACTOR FOR FRONT LINE
	ADD.W	#2*68,D1
	ADD.W	D1,D1
	LEA	(A1,D1.W),A5
	MOVE.W	(A5),D1

	LEA	(-56)*2(A6),A1		THIS ROUTINE ADDS THE XTRA FRONT LINE TO 
	LEA	DRAW_TABLE4+560,A3
	MOVE.W	ROUGH_Y(PC),D4

	MOVEQ	#13,D0
.LOOPS
	MOVE.W	(A1)+,D2
	MOVE.W	D2,-56(A3)

	MOVE.W	D2,(A3)+		GET X POINT
	MOVE.W	D4,D2	 		GET Y POINT
	MULS	D1,D2
	SWAP	D2
	ADD.W	#125,D2
	MOVE.W	D2,-56(A6)
	MOVE.W	D2,-56(A5)
	MOVE.W	D2,-56(A4)
	MOVE.W	D2,-56(A3)

	MOVE.W	D2,(A3)+		STORE Y POINT
	DBF	D0,.LOOPS

***********PRE FILL IN ALL THE X COORDINATES INTO THE DRAW TABLE**********

	LEA	PRE_CALC_TABLE,A1
	LEA	DRAW_TABLE4,A3

	MOVEQ	#8,D1
.LOOPX
	ADD.L	#28+28+28,A1
	MOVEQ	#13,D0
.LOOPZ1	
	MOVE.W	(A1)+,(A3)+		GET X POINT
	ADDQ.L	#2,A3
	DBF	D0,.LOOPZ1

	DBF	D1,.LOOPX

***********************************************************
* THESE LAST FEW LINES JUST MAKE SURE THAT A LITTLE ERROR *
* THAT OCCURS DURING DRAWING IS REMOVED. ITS TO DO WITH   *
* THE FRONT EDGES OF THE LANDSCAPE                        *
***********************************************************

	MOVE.W	#0,DRAW_TABLE4+448

	MOVE.W	#199,DRAW_TABLE4+500

*********************************************************
	RTS

*******************************************
* CONVERTS FORMAT OF POINTS INTO ONE WHICH*
* CAN BE MORE QUICKLY TURNED INTO A 3D    *
* POINT.                                  *
*******************************************

CONVERT_FORMAT:
**********PUT ALL AT SEA LEVEL AND ABOVE**********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
.LOOP1
	MOVE.W	(A0),D3
	SUB.W	WATER_LEVEL,D3
	BPL.S	.ITS_ALRIGHT
	MOVEQ	#0,D3
.ITS_ALRIGHT:
	MOVE.W	D3,(A0)+
	CMP.L	A0,A1
	BNE.S	.LOOP1
*************************************************

*********CONVERT INTO EASY FORMAT FOR CALCS******
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
.LOOP3
	MOVE.W	(A0),D3
	LSR.W	#3,D3
	NEG.W	D3
	BEQ.S	.DATA_OK
*********NEW LIMITER CODE TO PREVENT HEIGHT ERRORS***************
	CMP.W	#$FEF0,D3
	BGE.S	.DATA_OK
	MOVE.W	#$FEF0,D3
.DATA_OK:
	MOVE.W	D3,(A0)+
	CMP.L	A0,A1
	BNE.S	.LOOP3
*************************************************

	MOVE.W	FILL_STYLES(PC),D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	FILL_STYLES_TAB(PC,D0.W),A0
	JSR	(A0)
	RTS

FILL_STYLES_TAB:
	DC.L	0
	DC.L	DO_HEIGHT_COLORSA
	DC.L	DO_HEIGHT_COLORSB
	DC.L	DO_HEIGHT_COLORSA
	DC.L	DO_LIGHT

DO_HEIGHT_COLORSA:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	LSR.W	#5,D3
	MOVE.B	(A3,D3.W),(A2)+
	ADDQ.L	#2,A0
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#1,FILL_STYLES
	RTS

DO_HEIGHT_COLORSB:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	MOVE.W	(A0)+,D3
	NEG.W	D3
	LSR.W	#5,D3
	MOVE.B	(A3,D3.W),(A2)+
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#2,FILL_STYLES
	RTS

COLOR_TABLE_1:
	DC.B	1,15,1+8,2,16,2+8,10,10,10,10,10,10,10,10,10,10
	EVEN

DO_LIGHT:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	MOVE.W	66(A0),D4
	ADD.W	68(A0),D4

	ASR.W	#5,D3
	ASR.W	#5,D4

	SUB.W	D3,D4

	MOVE.W	(A0),D1
	ADD.W	66(A0),D1
	MOVE.W	2(A0),D2
	ADD.W	68(A0),D2

	ASR.W	#5,D1
	ASR.W	#5,D2

	SUB.W	D1,D2
	
	ADD.W	D2,D4

	ADDQ.W	#3,D4
	CMP.W	#1,D4
	BGE.S	.PLUS
	MOVEQ	#1,D4
	BRA.S	.OK
.PLUS	CMP.W	#6,D4
	BLE.S	.OK
	MOVEQ	#6,D4
.OK
	MOVE.B	D4,(A2)+
	ADDQ.L	#2,A0
	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#4,FILL_STYLES
CORRECT_WATER:
**********PUT WATER COLOR IN CORRECTLY***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	ADDQ.L	#1,A2
	ADDQ.L	#2,A0
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	RTS

**************************************************
* NOTES 400 IS LOWER LIMIT FOR THIS PROJECT AND  *
* DIVIDE TABLE.                                  *
**************************************************

X_OFFSET:	DC.W	6
Y_OFFSET:	DC.W	180
ROUGH_X:	DC.W	0
ROUGH_Y:	DC.W	180
ROUGH_Z:	DC.W	1740

*******************************************************
* STORES ALL THE POINTS INTO AN ARRAY FOR DRAWING     *
*******************************************************

MAKE_DRAW_ARRAY:
	MOVE.W	CURRENT_POS(PC),D0	FIRST GET GRID POSITION ACCORDING
	MULU	#66,D0
	LEA	MAP_ARRAY,A4
	ADD.L	D0,A4
	MOVEQ	#0,D0
	MOVE.W	X_OFFSET(PC),D0
	ADD.W	D0,D0
	ADD.L	D0,A4
	MOVE.W	Y_OFFSET(PC),D4
	MOVE.L	LOG_WATER(PC),A2
	LEA	EDIT_FRAME_STORE(PC),A0
	LEA	DRAW_TABLE4+2,A6
	MOVE.L	A6,CURRENT_DRAW_TABLE
	LEA	PRE_CALC_PERS+256+1536,A5

DRAW_ROUT4:
	LEA	-1536(A5),A3
	MOVEQ	#0,D2
	MOVE.B	(A3,D4.W),D2		ADD LINE TO RASTERS STORE FOR THE GROUND
	MOVE.B	D2,(A2)+
	MOVE.W	-2(A6),(A0)+
	MOVE.W	D2,(A0)+
	ADDQ.L	#2,A0
	LEA	16896(A3),A3
	MOVE.B	(A3,D4.W),D2		
	MOVE.W	D2,(A0)+
**************SAVES CLOCK CYCLES!!!**********************
.1	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.2	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.3	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.4	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.5	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.6	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.7	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.8	REPT	14
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	512(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.9
	MOVE.W	-66(A4),D3
	MOVE.W	(A4)+,D5		GET Y POINT
	SUB.W	D3,D5
	ASR.W	#2,D5
	ADD.W	D5,D3
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	LEA	1536(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
	REPT	12
	MOVE.W	(A4)+,D3		GET Y POINT
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	LEA	-1536(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
	MOVE.W	-66(A4),D3
	MOVE.W	(A4)+,D5		GET Y POINT
	SUB.W	D3,D5
	ASR.W	#2,D5
	ADD.W	D5,D3
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	LEA	38(A4),A4		IGNORE 16 POINTS (Y)
	LEA	2048(A5),A5		EVERY OTHER SET OF PRE CALCULATED Y DATA
.10	REPT	13
	MOVE.W	-66(A4),D3
	MOVE.W	(A4)+,D5		GET Y POINT
	SUB.W	D3,D5
	ASR.W	#2,D5
	ADD.W	D5,D3
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT
	ADDQ.L	#2,A6
	ENDR
	MOVE.W	-66(A4),D3
	MOVE.W	(A4)+,D5		GET Y POINT
	SUB.W	D3,D5
	ASR.W	#2,D5
	ADD.W	D5,D3
	ADD.W	D4,D3
	MOVE.B	(A5,D3.W),D2
	MOVE.W	D2,(A6)+		STORE Y POINT

	LEA	(A5,D4.W),A5		NO NEED TO KEEP ADDRESS NOW SO THIS SAVES A FEW CYCLES
	MOVE.B	(A5),(A2)+		ADD LINE TO RASTERS STORE FOR THE GROUND

	REPT	14			ADD IN EXTRA Y LINE
	ADDQ.L	#2,A6
	MOVE.B	(A5),D2
	MOVE.W	D2,(A6)+		
	ENDR

*********************************************************
	RTS

HIDDEN:	MACRO
	SUB.W	D0,D2			FOR FIRST TRIANGLE
	SUB.W	D1,D3
	SUB.W	D0,D4
	SUB.W	D1,D5
	MULS	D2,D5
	MULS	D3,D4
	SUB.L	D4,D5
	ENDM

THE_3D_BIT_LAYER:
	TST.B	(A2)			IF ITS SEA COLOR THEN GO NO FURTHER!
	BEQ.S	.OUT

	MOVE.L	(A1),D1			
	MOVE.L	4(A1),D2
	MOVE.L	4*14(A1),D3
	MOVEM.L	D1-D3,(A0)
	MOVEM.L	D1-D3,12(A0)

	MOVEM.W	(A0),D0-D5		HIDDEN SURFACE CHECK
	HIDDEN

	BMI.S	.HIDDEN1		AHH! NOT VISIBLE

	MOVE.W	4(A1),D0
	MOVE.W	6(A1),D1
	MOVE.W	4*15(A1),D2
	MOVE.W	(4*15)+2(A1),D3
	MOVE.W	4*14(A1),D4
	MOVE.W	(4*14)+2(A1),D5

	HIDDEN

	BPL.S	.DO_4_SIDED		GOOD NEWS WE CAN TRY IT AS A 4 SIDED POLY

*OK SO WE JUST DRAW THE FIRST TRIANGLE

	MOVEQ	#0,D0			GET COLOR
	MOVE.B	(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0
.OUT
	ADDQ.L	#1,A2
	ADDQ.L	#4,A1
	RTS

.HIDDEN1
	MOVE.L	4(A1),D1
	MOVE.L	4*15(A1),D2
	MOVE.L	4*14(A1),D3
	MOVEM.L	D1-D3,(A0)
	MOVEM.L	D1-D3,12(A0)

	MOVEM.W	(A0),D0-D5		HIDDEN SURFACE CHECK

	HIDDEN

	BMI.S	.HIDDEN2

	MOVEQ	#0,D0			*GET COLOR
	MOVE.B	(A2),D0

*DRAW THE SECOND TRIANGLE ONLY	

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0
.HIDDEN2
*WHAT A WASTE OF TIME. NO TRIANGLES DRAWN
	ADDQ.L	#1,A2	
	ADDQ.L	#4,A1
	RTS

* SO WE TRY AND DRAW A 4 SIDED TRIANGLE
* THIS IS NOT ALWAYS POSSIBLE IF THERE IS AN ANGLE OF MORE THAN 180 DEGS
* IN THE POLYGON. SO A SPECIAL ROUTINE THAT CHECKS FOR THIS INSTANCE
* IS USED, BUT THE VAST MAJORITY OF POLYGONS WITH 4 SIDES CAN BE DRAWN
* SO WE DON'T LOSE ANYTHING BY TRYING!!

.DO_4_SIDED:
	MOVE.L	(A1),D1
	MOVE.L	4(A1),D2
	MOVE.L	4*15(A1),D3
	MOVE.L	4*14(A1),D4
	MOVEM.L	D1-D4,(A0)
	MOVEM.L	D1-D4,16(A0)
	MOVEQ	#0,D0			*GET COLOR
	MOVE.B	(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_4_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0
.OUT1
	ADDQ.L	#1,A2
	ADDQ.L	#4,A1
	RTS

*********************************************
* THIS DRAWS A 3D VERSION OF THE FRACTAL    *
* CURRENTLY HELD IN 'DRAW TABLE'            *
*********************************************

DRAW_3D_VERSION:
	LEA	EDIT_FRAME_STORE(PC),A0
	BSR	DO_SIDES
	MOVE.L	CURRENT_DRAW_TABLE(PC),A1
	SUBQ.L	#2,A1
	LEA	POLY_SURFACES,A0
	LEA	COLOR_ARRAY,A2
	LEA	OBJECT_ARRAY,A3
	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS(PC),D0
	LSL.L	#5,D0				*MULU	#32
	ADD.L	D0,A2
	ADD.L	D0,A3
	MOVEQ	#0,D0
	MOVE.W	X_OFFSET(PC),D0
	ADD.L	D0,A2
	ADD.L	D0,A3
	MOVE.L	A3,CURRENT_OBJECT_POS	
	MOVE.W	#0,DEPTH

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19,A2
	JSR	DRAW_OBJECT_LINE

	REPT	13
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADDQ.L	#4,A1
	ADD.L	#19+1,A2
	JSR	DRAW_OBJECT_LINE
	ADDQ.L	#4,A1

	REPT	11
	BSR	THE_3D_BIT_LAYER
	ENDR
	ADD.L	#4+4+4,A1
	ADD.L	#19+1+1,A2
	JSR	DRAW_OBJECT_LINE2

	REPT	11
	BSR	THE_3D_BIT_LAYER
	ENDR

	ADD.L	#4+4+4,A1
	ADD.L	#19+1+1,A2

***********************THIS BIT DRAWS THE FRONT*********************
***********BLANK LAYER ON THE SCREEN USING A SPECIALLY WRITTEN******
******************************FILL ROUTINE**************************

ADDIT	SET	0
	REPT	5
	MOVE.L	(A1)+,D0
	MOVE.L	(A1),D1
	MOVE.L	4*14(A1),D2
	MOVE.L	4*13(A1),D3
	MOVE.L	(A1)+,D4
	MOVE.L	(A1),D5
	MOVE.L	4*14(A1),D6
	MOVE.L	4*13(A1),D7
	MOVEM.L	D0-D3,ADDIT(A0)
	MOVEM.L	D0-D7,ADDIT+16(A0)
	MOVEM.L	D4-D7,ADDIT+48(A0)
ADDIT	SET	ADDIT+64
	ENDR
	MOVE.L	(A1)+,D0
	MOVE.L	(A1),D1
	MOVE.L	4*14(A1),D2
	MOVE.L	4*13(A1),D3
	MOVE.L	(A1)+,D4
	MOVE.L	(A1),D5
	MOVE.L	4*14(A1),D6
	MOVE.L	4*13(A1),D7
	MOVEM.L	D0-D3,ADDIT(A0)
	MOVEM.L	D0-D7,ADDIT+16(A0)
	MOVEM.L	D4-D7,ADDIT+48(A0)

	REPT	11
	MOVE.L	A0,-(A7)	*PRESERVE REGS
	BSR	POLY_4_SPECIAL	*EXECUTE POLY DRAW
	MOVE.L	(A7)+,A0
	LEA	32(A0),A0
	ENDR
	RTS

***********************************************
*NEW POLYGON ROUTINES. ONE FOR 3 VERTICES AND *
* ONE FOR 4 VERTICES. OPTIMIZED FOR EACH.     *
***********************************************

SET_UP_COLORS:	MACRO
	LEA 	COL0(PC),A2		*D0 CONTAINS COLOR
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D1,D0
	MOVEM.L (A2,D0.W),D1/D7/A5
	LEA	MOD1+2(PC),A2
	MOVE.L	D1,(A2)
	MOVE.L	D1,MOD2-MOD1(A2)
	MOVE.L	D1,MOD3-MOD1(A2)
	MOVE.L	D1,MOD4-MOD1(A2)
	ENDM

* THE NEXT ROUTINES (POLY_3_SIDED & POLY_4_SIDED) ARE FOR POLYS OF >16

*D0 = COLOR
*A0 = ADDRESS OF SURFACES

POLY_3_SIDED:

	SET_UP_COLORS			*SEE MACROS

	MOVE.L	(A0)+,D4
	MOVE.L	D4,D1
	MOVE.L	A0,A4

	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.2
	MOVE.W 	D3,D4
.2
	CMP.W	D3,D1
	BLE.S	.22
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.22
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.3
	MOVE.W 	D3,D4
.3
	CMP.W	D3,D1
	BLE.S	.33
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.33

	MOVE.L	A4,A3
	SUBQ.L	#4,A4
	ADDQ.L	#12-4,A3

	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ 	ABORT_POLY		*0 LINES TO DRAW!!

.FLAT_CHECK:
	MOVE.L 	(A4)+,D0
.FLAT_CHECK1:
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2
	ADDQ.L 	#4,A4			*YEP IT IS 
.FLAT_CHECK2:
	CMP.W 	-2(A3),D0
	BNE.S 	.FLAT_DONE
	SUBQ.L 	#4,A3
.FLAT_DONE:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	MOVE.W	D0,BIT_MASK
	LSL.W	#5,D0
	ADD.W	D0,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A6

.CALC_POLYGON:
	LEA	POLYGON_IMG(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	4(A3),D1

	BEQ.S 	.VERTICAL_GRADIENT

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	BRA.S 	.MAKE_LEFT_COORDINATES

.VERTICAL_GRADIENT:
	SUB.W	D5,D6
	SUBQ.W	#1,D5
	SWAP	D3
.LOOPS:
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOPS
	TST.W	D6
	BNE.S	.LEFT_AGAIN
	BRA	.DO_RIGHT
	
.MAKE_LEFT_COORDINATES:
	SUB.W	D5,D6
	MOVEQ	#0,D0
	SWAP	D1
	SWAP	D3
	LEA	.CALC_TABLEB3(PC),A2
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLEB3:

	TST.W	D6
	BNE	.LEFT_AGAIN
	
*DO RIGHT HAND OF POLYGON

.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W	D4,D6
	
RIGHT_AGAIN1:
	MOVE.L 	-4(A4),D3
	MOVE.W  (A4)+,D1
	MOVE.W  (A4)+,D5
	SUB.W   D3,D5
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A4),D1

	BEQ.S 	.VERTICAL_GRADIENT2

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
	BRA.S 	MAKE_RIGHT_COORDINATES1

.VERTICAL_GRADIENT2:
	SUB.W	D5,D6
	SUBQ.W	#1,D5
	SWAP	D3
.LOOP1B:
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOP1B
	TST.W	D6
	BNE.S	RIGHT_AGAIN1
MOD1:	JMP	DRAW_POLYGON1

MAKE_RIGHT_COORDINATES1:
	SUB.W	D5,D6
	MOVEQ	#0,D0
	SWAP	D1
	SWAP	D3
	LEA	.CALC_TABLEB2(PC),A2
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLEB2:

	TST.W	D6
	BNE	RIGHT_AGAIN1
MOD2:	JMP	DRAW_POLYGON1

*D0 = COLOR
*A0 = ADDRESS OF SURFACES

POLY_4_SIDED:

	SET_UP_COLORS			*SEE MACROS

	MOVE.L	(A0)+,D4
	MOVE.L	D4,D1
	MOVE.L	A0,A4

	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.2
	MOVE.W 	D3,D4
.2
	CMP.W	D3,D1
	BLE.S	.22
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.22
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.3
	MOVE.W 	D3,D4
.3
	CMP.W	D3,D1
	BLE.S	.33
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.33
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.4
	MOVE.W 	D3,D4
.4
	CMP.W	D3,D1
	BLE.S	.44
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.44

	MOVE.L	A4,A3
	SUBQ.L	#4,A4
	ADD.L	#16-4,A3

	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ 	ABORT_POLY		*0 LINES TO DRAW!!

.FLAT_CHECK:
	MOVE.L 	(A4)+,D0
.FLAT_CHECK1:
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2
	ADDQ.L 	#4,A4			*YEP IT IS 
.FLAT_CHECK2:
	CMP.W 	-2(A3),D0
	BNE.S 	.FLAT_DONE
	SUBQ.L 	#4,A3
.FLAT_DONE:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	MOVE.W	D0,BIT_MASK
	LSL.W	#5,D0
	ADD.W	D0,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A6

.CALC_POLYGON:
	LEA	POLYGON_IMG(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	BLE	ABORT_POLYGON2			*ILLEGAL POLYGON?
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	4(A3),D1

	BEQ.S 	.VERTICAL_GRADIENT

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	BRA.S 	.MAKE_LEFT_COORDINATES

.VERTICAL_GRADIENT:
	SUB.W	D5,D6
	SUBQ.W	#1,D5
	SWAP	D3
.LOOPS:
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOPS
	TST.W	D6
	BNE.S	.LEFT_AGAIN
	BRA	.DO_RIGHT

.MAKE_LEFT_COORDINATES:
	SUB.W	D5,D6
	MOVEQ	#0,D0
	SWAP	D1
	SWAP	D3
	LEA	.CALC_TABLE(PC),A2
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLE:
	TST.W	D6
	BNE	.LEFT_AGAIN
	
*DO RIGHT HAND OF POLYGON
.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W	D4,D6
	
RIGHT_AGAIN2:
	MOVE.L 	-4(A4),D3
	MOVE.W  (A4)+,D1
	MOVE.W  (A4)+,D5
	SUB.W   D3,D5
	BLE	ABORT_POLYGON2			ILLEGAL POLYGON?
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A4),D1

	BEQ.S 	.VERTICAL_GRADIENT2

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
	BRA.S 	MAKE_RIGHT_COORDINATES2

.VERTICAL_GRADIENT2:
	SUB.W	D5,D6
	SUBQ.W	#1,D5
	SWAP	D3
.LOOP1S:
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOP1S
	TST.W	D6
	BNE.S	RIGHT_AGAIN2
MOD3:	JMP	DRAW_POLYGON1

MAKE_RIGHT_COORDINATES2:
	SUB.W	D5,D6
	MOVEQ	#0,D0
	SWAP	D1
	SWAP	D3
	LEA	.CALC_TABLEB(PC),A2
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLEB:
	TST.W	D6
	BNE	RIGHT_AGAIN2
MOD4:	JMP	DRAW_POLYGON1

ABORT_POLYGON2:
	ADDQ.L	#4,SP			*ADJUST THE STACK A TO TAKE
	MOVE.L	(A7)+,A2		*TO TAKE BSR INTO ACCOUNT
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0

	MOVE.L	(A1),D1			
	MOVE.L	4(A1),D2
	MOVE.L	4*14(A1),D3
	MOVEM.L	D1-D3,(A0)
	MOVEM.L	D1-D3,12(A0)

	MOVEQ	#0,D0			GET COLOR
	MOVE.B	(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0

	MOVE.L	4(A1),D1
	MOVE.L	4*15(A1),D2
	MOVE.L	4*14(A1),D3
	MOVEM.L	D1-D3,(A0)
	MOVEM.L	D1-D3,12(A0)

	MOVEQ	#0,D0			*GET COLOR
	MOVE.B	(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES,A0

	ADDQ.L	#1,A2	
	ADDQ.L	#4,A1
	RTS

***************************************
* BITS FOR THE SELF MODIFYING COLOR   *
* ROUTINES                            *
***************************************

COL0
	DC.L	DRAW_POLYGON1
	DC.L 	$FFFF0000,$00000000
	DC.L	DRAW_POLYGON2
	DC.L 	$0000FFFF,$00000000
	DC.L	DRAW_POLYGON3
	DC.L 	$FFFFFFFF,$00000000
	DC.L	DRAW_POLYGON4
	DC.L 	$00000000,$FFFF0000
	DC.L	DRAW_POLYGON5
	DC.L 	$FFFF0000,$FFFF0000
	DC.L	DRAW_POLYGON6
	DC.L 	$0000FFFF,$FFFF0000
	DC.L	DRAW_POLYGON7
	DC.L 	$FFFFFFFF,$FFFF0000
	DC.L	DRAW_POLYGON8
	DC.L 	$00000000,$0000FFFF
	DC.L	DRAW_POLYGON9
 	DC.L 	$FFFF0000,$0000FFFF
	DC.L	DRAW_POLYGON10
	DC.L	$0000FFFF,$0000FFFF
	DC.L	DRAW_POLYGON11
	DC.L 	$FFFFFFFF,$0000FFFF
	DC.L	DRAW_POLYGON12
	DC.L 	$00000000,$FFFFFFFF
	DC.L	DRAW_POLYGON13
	DC.L 	$FFFF0000,$FFFFFFFF
	DC.L	DRAW_POLYGON14
	DC.L	$0000FFFF,$FFFFFFFF
	DC.L	DRAW_POLYGON15
	DC.L 	$FFFFFFFF,$FFFFFFFF
	DC.L	DRAW_POLYGON16
	DC.L 	$0000FFFF,$00000000
	DC.L	DRAW_POLYGON17
	DC.L 	$FFFFFFFF,$00000000

POLYGON_COLOR:	MACRO

DRAW_POLYGON\1:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVEQ	#15,D3
	MOVEQ	#16,D5
	MOVEQ	#32,D6
	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2
.FIRST_CHUNK

	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	SUB.W 	D5,D0
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER
	CMP.W	D6,D0
	BLT.S	.FILL_TOWER-4

	MOVE.L 	D7,(A0)+
	MOVE.L 	A5,(A0)+		
	MOVE.L 	D7,(A0)+
	MOVE.L 	A5,(A0)+		
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
.END_CHUNK

	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

	ENDM


	POLYGON_COLOR	1,OR,AND,AND,AND,1,2,2,2
	POLYGON_COLOR	2,AND,OR,AND,AND,2,1,2,2
	POLYGON_COLOR	3,OR,OR,AND,AND,1,1,2,2
	POLYGON_COLOR	4,AND,AND,OR,AND,2,2,1,2
	POLYGON_COLOR	5,OR,AND,OR,AND,1,2,1,2
	POLYGON_COLOR	6,AND,OR,OR,AND,2,1,1,2
	POLYGON_COLOR	7,OR,OR,OR,AND,1,1,1,2
	POLYGON_COLOR	8,AND,AND,AND,OR,2,2,2,1
	POLYGON_COLOR	9,OR,AND,AND,OR,1,2,2,1
	POLYGON_COLOR	10,AND,OR,AND,OR,2,1,2,1
	POLYGON_COLOR	11,OR,OR,AND,OR,1,1,2,1
	POLYGON_COLOR	12,AND,AND,OR,OR,2,2,1,1
	POLYGON_COLOR	13,OR,AND,OR,OR,1,2,1,1
	POLYGON_COLOR	14,AND,OR,OR,OR,2,1,1,1
	POLYGON_COLOR	15,OR,OR,OR,OR,1,1,1,1

BIT_MASK:	DC.W	0

DRAW_POLYGON16:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#16,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2
.FIRST_CHUNK

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER
	CMP.W	#32,D0
	BLT.S	.FILL_TOWER-6

	MOVE.L 	D7,(A0)+
	MOVE.W	A5,(A0)+
	MOVE.W	D6,(A0)+
	MOVE.L 	D7,(A0)+
	MOVE.W	A5,(A0)+
	MOVE.W	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
.END_CHUNK

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON17:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#16,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2
.FIRST_CHUNK

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER
	CMP.W	#32,D0
	BLT.S	.FILL_TOWER-6

	MOVE.L 	D7,(A0)+
	MOVE.W	A5,(A0)+
	MOVE.W	D6,(A0)+
	MOVE.L 	D7,(A0)+
	MOVE.W	A5,(A0)+
	MOVE.W	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
.END_CHUNK

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

*A0 = ADDRESS OF SURFACES

POLY_4_SPECIAL:
	MOVE.W	2(A0),D1
	MOVE.W	6(A0),D3
	CMP.W	D1,D3
	BGE	ROUT2
********THE SPECIAL POLY ROUT FOR WHEN RIGHT TOP POINT IS HIGHEST ***********
.ROUT1:
	LEA	4(A0),A4		*RIGHT BIAS
	LEA	20(A0),A3
	MOVE.W 	14(A0),D4		MAX COORDINATE
	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ	ABORT_POLY

	MOVE.L 	(A4)+,D0
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2A
	ADDQ.L 	#4,A4			*YEP IT IS 
	BRA	ROUT3			*ITS A RECTANGLE !!!
.FLAT_CHECK2A:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	LEA	TAB_160,A2
	ADD.W	D0,D0
	ADD.W	(A2,D0.W),A6

	LEA	POLYGON_IMG(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	4(A3),D1

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	SUB.W	D5,D4
	SUBQ.W	#1,D5
	MOVE.W	D5,D6
	SWAP	D1
	SWAP	D3
	MOVEQ	#0,D0
.LOOP:	ADD.L	D1,D3
	ADDX.W	D0,D3
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOP

*DO RIGHT HAND OF POLYGON
.DO_RIGHT:

	LEA	POLYGON_IMG+400(PC),A0
.RIGHT_AGAIN:
	MOVE.W 	-4(A4),(A0)
	BRA.S	.DRAW_POLYGON

.LEFT_MASKS:
	DC.W	%1111111111111111
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001
.RIGHT_MASKS
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111

.DRAW_POLYGON:
	LEA	POLYGON_IMG(PC),A1
	MOVEQ	#15,D3
	MOVEQ	#-1,D7			SET COLOR (FRONT POLY DRAWER)

	MOVE.W	POLYGON_IMG+400(PC),D0
	MOVE.W	D0,A2
	AND.W	D3,D0
	ADD.W	D0,D0
	MOVE.W	.RIGHT_MASKS(PC,D0.W),D5
	
.POLYFILL_LOOP:
	MOVE.W	(A1)+,D0
	MOVE.W	A2,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	.LEFT_MASKS(PC,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS

	AND.W 	D5,D2			

	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+

	LEA 	160(A6),A6
	DBF	D6,.POLYFILL_LOOP
	TST.W	D4
	BNE	RIGHT_BIAS_BUST_IN
	RTS

.MULTI_CHUNK
.FIRST_CHUNK

	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W	D2,(A0)+
	OR.W    D2,(A0)+

	SUB.W 	#16,D0
	AND.W 	#48,D0

	BEQ.S	.FILL_TOWER
	MOVE.L 	D7,(A0)+
	MOVE.L 	D7,(A0)+		
.FILL_TOWER:
.END_CHUNK

	OR.W    D5,(A0)+
	OR.W    D5,(A0)+
	OR.W    D5,(A0)+
	OR.W    D5,(A0)+

	LEA 	160(A6),A6
	DBF	D6,.POLYFILL_LOOP
	TST.W	D4
	BNE	RIGHT_BIAS_BUST_IN
.ABORT_POLY:
	RTS


*****THE SPECIAL POLYGON ROUT FOR WHEN LEFT MOST POINT IS HIGHEST**********
ROUT2:
	LEA	(A0),A4			*LEFT BIAS
	LEA	16(A0),A3

	MOVE.W 	14(A0),D4		MAX COORDINATE
	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ	ABORT_POLY

	MOVE.L 	(A4)+,D0
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2B
	ADDQ.L 	#4,A4			*YEP IT IS 
	BRA	ROUT3			*ITS A RECTANGLE !!!
.FLAT_CHECK2B:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	LEA	TAB_160,A2
	ADD.W	D0,D0
	ADD.W	(A2,D0.W),A6

	LEA	POLYGON_IMG(PC),A0
	MOVE.W 	(A3),D2			*STORE X1 COORD(ALWAYS SAME FOR THIS ROUT)
	MOVE.W	D2,(A0)
	AND.W	#$FFF0,D2

*DO RIGHT HAND OF POLYGON
.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	MOVE.W	D4,D6
	
.RIGHT_AGAIN:
	MOVE.L 	-4(A4),D3
	MOVE.W  (A4)+,D1
	MOVE.W  (A4)+,D5
	SUB.W   D3,D5
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A4),D1

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	SUB.W	D5,D4
	SUBQ.W	#1,D5
	MOVE.W	D5,D6			*GET LENGTH OF TRIANGLE FRAGMENT
	SWAP	D1
	SWAP	D3
	SUB.W	D2,D3			*MINUS X1!!!
	MOVEQ	#0,D0
.LOOP1:	ADD.L	D1,D3
	ADDX.W	D0,D3
	MOVE.W	D3,(A0)+
	DBF	D5,.LOOP1
	BRA.S	.DRAW_POLYGON

.LEFT_MASKS:
	DC.W	%1111111111111111
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001

.DRAW_POLYGON
	LEA	POLYGON_IMG+400(PC),A2

	MOVEQ	#15,D3
	MOVEQ	#-1,D7			SET COLOR (FRONT POLY DRAWER)
	MOVE.W	#16,A3

	MOVE.W	POLYGON_IMG(PC),D1
	MOVE.W	D1,D2
	AND.W	D3,D1
	SUB.W	D1,D2
	LSR.W	#1,D2	
	ADD.W	D2,A6	
	ADD.W	D1,D1
	MOVE.W	.LEFT_MASKS(PC,D1.W),D5

.POLYFILL_LOOP:
	MOVE.W	(A2)+,D0		*GET X1 TO X2 DISTANCE

	MOVE.L	A6,A0
	MOVE.W	D5,D2

	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	.RIGHT_MASKS(PC,D0.W),D2			

	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	LEA 	160(A6),A6
	DBF	D6,.POLYFILL_LOOP
	TST.W	D4
	BNE	LEFT_BIAS_BUST_IN
	RTS

.MULTI_CHUNK
.FIRST_CHUNK

	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+
	OR.W    D2,(A0)+

	SUB.W 	A3,D0
	MOVE.W 	D0,D1
	AND.W 	#48,D0
	BEQ.S	.FILL_TOWER
	MOVE.L 	D7,(A0)+
	MOVE.L 	D7,(A0)+		
.FILL_TOWER:
	ADD.W 	D1,D1
	MOVE.W 	.RIGHT_MASKS(PC,D1.W),D1 
.END_CHUNK

	OR.W    D1,(A0)+
	OR.W    D1,(A0)+
	OR.W    D1,(A0)+
	OR.W    D1,(A0)+

	LEA 	160(A6),A6
	DBF	D6,.POLYFILL_LOOP
.ABORT_POLY:
	TST.W	D4
	BNE	LEFT_BIAS_BUST_IN
	RTS

.RIGHT_MASKS
	REPT	4
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111
	ENDR

*****THE SPECIAL POLYGON ROUT FOR DRAWING A RECTANGLE **********
ROUT3:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	LEA	TAB_160,A2
	ADD.W	D0,D0
	ADD.W	(A2,D0.W),A6		*AND ADD THE HIGHEST Y POS

	LEA	POLYGON_IMG(PC),A0
	MOVE.W 	(A3),D2			
	MOVE.W	D2,(A0)			*STORE X1 COORD
	AND.W	#$FFF0,D2

	LEA	POLYGON_IMG+400(PC),A0

	MOVE.W 	-4(A4),D3
	SUB.W	D2,D3			
	MOVE.W	D3,(A0)			*AND STORE X1 TO X2 DIST
	BRA.S	DRAW_RECTANGLE

*************************************************
* ROUTINE FOR DRAWING BOTTOM RECTANGLE OF LEFT  *
* BIASED FRONT SHAPE                            *
*************************************************

LEFT_BIAS_BUST_IN:
	MOVE.W	POLYGON_IMG(PC),D2
	MOVE.W	D2,D1
	AND.W	#$FFF0,D2
	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W 	-4(A4),D3
	SUB.W	D2,D3			*DIST FROM X1 TO X2
	MOVE.W	D3,(A0)

	AND.W	#15,D1
	ADD.W	D1,D1			*GET LEFT MASK
	MOVE.W	REC_LEFT_MASKS(PC,D1.W),D2
	BRA.S	DRAW_RECTANGLE1

*************************************************
* ROUTINE FOR DRAWING BOTTOM RECTANGLE OF RIGHT *
* BIASED FRONT SHAPE                            *
*************************************************

RIGHT_BIAS_BUST_IN:
	LEA	POLYGON_IMG(PC),A0
	MOVE.W 	(A3),D2			
	MOVE.W	D2,(A0)			*STORE X1 COORD
	AND.W	#$FFF0,D2

	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W 	-4(A4),D3
	SUB.W	D2,D3			DIST FROM X1 TO X2
	MOVE.W	D3,(A0)
	BRA.S	DRAW_RECTANGLE

REC_LEFT_MASKS:
	DC.W	%1111111111111111
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001
REC_RIGHT_MASKS
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111

DRAW_RECTANGLE:
	MOVE.W	POLYGON_IMG(PC),D1
	MOVE.W	D1,D2
	AND.W	#15,D1
	SUB.W	D1,D2
	LSR.W	#1,D2	
	ADD.W	D2,A6	
	ADD.W	D1,D1
	MOVE.W	REC_LEFT_MASKS(PC,D1.W),D2

DRAW_RECTANGLE1:
	SUBQ.W	#1,D4

	MOVEQ	#15,D3
	MOVEQ	#-1,D7			SET COLOR (FRONT POLY DRAWER)
	MOVEQ	#16,D6			FOR A SUB

	MOVE.W	POLYGON_IMG+400(PC),A2			GET WIDTH
	MOVE.W	A2,D1
	AND.W	D3,D1
	ADD.W	D1,D1
	MOVE.W	REC_RIGHT_MASKS(PC,D1.W),D1
	SUB.W	D6,A2
	CMP.W	D6,A2
	BGE.S	.WITH_MIDDLE

.POLYFILL_LOOP:

	OR.W    D2,(A6)+		*MASK IN D3
	OR.W    D2,(A6)+
	OR.W    D2,(A6)+
	OR.W    D2,(A6)+

	OR.W    D1,(A6)+		*MASK IN D5
	OR.W    D1,(A6)+
	OR.W	D1,(A6)+
	OR.W    D1,(A6)+

	LEA 	144(A6),A6
	DBF	D4,.POLYFILL_LOOP
.ABORT_POLY:
	RTS

.WITH_MIDDLE:
	OR.W    D2,(A6)+		*MASK IN D3
	OR.W    D2,(A6)+
	OR.W    D2,(A6)+
	OR.W    D2,(A6)+

	MOVE.L 	D7,(A6)+
	MOVE.L 	D7,(A6)+		

	OR.W    D1,(A6)+		*MASK IN D5
	OR.W    D1,(A6)+
	OR.W	D1,(A6)+
	OR.W    D1,(A6)+

	LEA 	136(A6),A6
	DBF	D4,.WITH_MIDDLE
	RTS

ABORT_POLY:	RTS

POLYGON_IMG:	DS.W	400

*********************************************************
* SPECIAL POLYGON ROUTINE TO ERASE THE SIDES PROJECTING *
* BEYOND THE RANGE OF THE COORDINATES ON THE RIGHT AND  *
* LEFT OF THE SCREEN.                                   *
*********************************************************

DO_SIDES:
	MOVE.W	6(A0),D4
	SUB.W 	2(A0),D4		ISOLATES THE HEIGHT OF THE POLYGON

	MOVE.W	2(A0),D0		WORK OUT BEGINNING SCREEN POS

	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS
	LEA	TAB_160,A2
	ADD.W	D0,D0
	ADD.W	(A2,D0.W),A6

	LEA	GRAD_TABLE+640(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	
	MOVE.L 	(A0)+,D3
	MOVE.W  (A0)+,D1
	MOVE.W  (A0)+,D5
	SUB.W   D3,D5			GET Y DIST
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A0),D1			AND X DIST

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	SUBQ.W	#1,D5
	MOVEQ	#0,D0
	SWAP	D1
	SWAP	D3
.LOOP1:	ADD.L	D1,D3
	ADDX.W	D0,D3
	MOVE.W	D3,(A2)+
	DBF	D5,.LOOP1

	MOVEQ	#0,D7
	LEA	POLYGON_IMG+400(PC),A2
	MOVEQ	#15,D3
	MOVEQ	#16,D5
	MOVE.W	#%11110000,D6
	SUBQ.W	#1,D4
	LEA	.RIGHT_MASKS(PC),A3

.POLYFILL_LOOP:
	MOVE.W	(A2)+,D0
	MOVE.L	A6,A0
	LEA	160(A6),A1

	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.W 	(A3,D0.W),D2			
	MOVE.W	2(A3,D0.W),D1

	AND.W	D2,(A0)+
	AND.W	D2,(A0)+
	AND.W	D2,(A0)+
	AND.W	D2,(A0)+
	AND.W	D1,-(A1)
	AND.W	D1,-(A1)
	AND.W	D1,-(A1)
	AND.W	D1,-(A1)

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK

	MOVE.W 	D0,D1
	AND.W 	D6,D0
	LSR.W	#1,D0
	NEG.W	D0
	JMP	.FILL_TOWER(PC,D0.W)
	REPT	10
	MOVE.L 	D7,(A0)+
	MOVE.L 	D7,(A0)+		
	MOVE.L 	D7,-(A1)
	MOVE.L 	D7,-(A1)		
	ENDR
.FILL_TOWER:
	ADD.W 	D1,D1
	ADD.W 	D1,D1
	MOVE.W 	2(A3,D1.W),D2 
	MOVE.W 	(A3,D1.W),D1 
.END_CHUNK

	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D2,-(A1)
	AND.W	D2,-(A1)
	AND.W	D2,-(A1)
	AND.W	D2,-(A1)

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
.ABORT_POLY:
	RTS

.RIGHT_MASKS
	REPT	7
	DC.W	%0111111111111111,%1111111111111110
	DC.W	%0011111111111111,%1111111111111100
	DC.W	%0001111111111111,%1111111111111000
	DC.W	%0000111111111111,%1111111111110000
	DC.W	%0000011111111111,%1111111111100000
	DC.W	%0000001111111111,%1111111111000000
	DC.W	%0000000111111111,%1111111110000000
	DC.W	%0000000011111111,%1111111100000000
	DC.W	%0000000001111111,%1111111000000000
	DC.W	%0000000000111111,%1111110000000000
	DC.W	%0000000000011111,%1111100000000000
	DC.W	%0000000000001111,%1111000000000000
	DC.W	%0000000000000111,%1110000000000000
	DC.W	%0000000000000011,%1100000000000000
	DC.W	%0000000000000001,%1000000000000000
	DC.W	%0000000000000000,%0000000000000000
	ENDR


GRAD_TABLE:	INCBIN	E:\KSPREE.TLB\GRAD_TAB.DAT

********************END OF POLYGON ROUTINE******************

CLEAR_LOGBASE:
	MOVE.L	LOGBASE(PC),A0
	LEA	152*160(A0),A0
	MOVE.L	CLEAR_BUFFER_POINT(PC),A1	GET Y OFFSET LAST TIME
	MOVE.W	(A1),D0				THIS SCREEN WAS CLEARED
	LSR.W	#2,D0
	LSL.W	#5,D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D1,D0
	ADD.W	D0,A0
	MOVEM.L	BLANK(PC),D0-D7/A1-A6
	REPT	343
	MOVEM.L	D0-D7/A1-A6,-(A0)
	ENDR

	RTS

LEFT_MASKS:
	DC.W	%1111111111111111
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001

	DS.W	16
RIGHT_MASKS
	REPT	4
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111
	ENDR

********************************************************
* ROUTINE FOR DRAW THE LARGE 2D VERSION OF THE MAP     *
********************************************************

DRAW_2D_VERSION:
	MOVE.L	LOGBASE(PC),A1
	ADD.L	#(120*160)+128,A1
	LEA	CUR_TEXT_SPACE(PC),A0
	
	MOVEQ	#15,D7
.LOOP:
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	LEA	128(A1),A1
	DBF	D7,.LOOP

	LEA	320+16(A1),A1

	LEA	OBJECT_LIST2,A4
	MOVEQ	#0,D0
	MOVE.B	CURRENT_OBJECT(PC),D0
	LSL.W	#4,D0
	ADD.W	D0,A4

	MOVEQ	#7,D7
.LOOP3:
	MOVE.B	(A4)+,D0
	MOVE.B	D0,(A1)
	MOVE.B	D0,2(A1)
	MOVE.B	D0,4(A1)
	MOVE.B	D0,6(A1)
	LEA	160(A1),A1
	DBF	D7,.LOOP3

	MOVE.L	A4,A0
	MOVE.L	A1,-(A7)
	BSR	DRAW_OBJECT_TEXT
	MOVE.L	(A7)+,A1

	LEA	320-16(A1),A1
	LEA	CUR_OBJECT_TEXT_SPACE(PC),A0
	
	MOVEQ	#7,D7
.LOOP1:
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	(A0)+,D0
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A1)+
	LEA	128(A1),A1
	DBF	D7,.LOOP1

	LEA	COLOR_ARRAY,A0
	LEA	OBJECT_ARRAY,A4
	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS(PC),D0
	LSL.L	#5,D0
	ADD.L	D0,A0
	ADD.L	D0,A4
	MOVE.L	LOGBASE(PC),A1
	ADD.L	#(80*160),A1
	LEA	COLOR_DATA_2D(PC),A2

	MOVEQ	#14,D0
.LOOP_A:
	MOVEQ	#15,D1
.LOOP_B:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	ADD.W	D2,D2
	MOVE.W	D2,D3
	ADD.W	D2,D2
	ADD.W	D2,D2
	ADD.W	D3,D2
	MOVEM.W	(A2,D2.W),D3-D7
ADDIT	SET	0
	REPT	4
	MOVE.B	D3,ADDIT(A1)
	MOVE.B	D4,ADDIT+2(A1)
	MOVE.B	D5,ADDIT+4(A1)
	MOVE.B	D6,ADDIT+6(A1)
	MOVE.B	D3,ADDIT+160(A1)
	MOVE.B	D4,ADDIT+162(A1)
	MOVE.B	D5,ADDIT+164(A1)
	MOVE.B	D7,ADDIT+166(A1)
ADDIT	SET	ADDIT+320
	ENDR
	MOVEQ	#0,D2
	MOVE.B	(A4)+,D2
	BEQ	.NO_ICON1
	LSL.W	#4,D2
	LEA	OBJECT_LIST2(PC),A5
	ADD.W	D2,A5

ADDIT	SET	0
	REPT	8
	MOVE.B	(A5)+,D2
	AND.B	D2,ADDIT(A1)
	AND.B	D2,ADDIT+2(A1)
	AND.B	D2,ADDIT+4(A1)
	AND.B	D2,ADDIT+6(A1)
ADDIT	SET	ADDIT+160
	ENDR
.NO_ICON1:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	ADD.W	D2,D2
	MOVE.W	D2,D3
	ADD.W	D2,D2
	ADD.W	D2,D2
	ADD.W	D3,D2
	MOVEM.W	(A2,D2.W),D3-D7
ADDIT	SET	0
	REPT	4
	MOVE.B	D3,ADDIT+1(A1)
	MOVE.B	D4,ADDIT+3(A1)
	MOVE.B	D5,ADDIT+5(A1)
	MOVE.B	D6,ADDIT+7(A1)
	MOVE.B	D3,ADDIT+161(A1)
	MOVE.B	D4,ADDIT+163(A1)
	MOVE.B	D5,ADDIT+165(A1)
	MOVE.B	D7,ADDIT+167(A1)
ADDIT	SET	ADDIT+320
	ENDR

	MOVEQ	#0,D2
	MOVE.B	(A4)+,D2
	BEQ	.NO_ICON2
	LSL.W	#4,D2
	LEA	OBJECT_LIST2(PC),A5
	ADD.W	D2,A5

ADDIT	SET	0
	REPT	8
	MOVE.B	(A5)+,D2
	AND.B	D2,ADDIT+1(A1)
	AND.B	D2,ADDIT+3(A1)
	AND.B	D2,ADDIT+5(A1)
	AND.B	D2,ADDIT+7(A1)
ADDIT	SET	ADDIT+160
	ENDR
.NO_ICON2:

	ADDQ.L	#8,A1
	DBF	D1,.LOOP_B
	LEA	(160*7)+32(A1),A1
	DBF	D0,.LOOP_A
	
	MOVE.L	LOGBASE(PC),A0
	MOVE.W	ICON_Y(PC),D0
	AND.W	#%1111111111111000,D0
	MULU	#160,D0
	ADD.W	D0,A0
	MOVE.W	ICON_X(PC),D0
	AND.W	#%1111111111111000,D0
	MOVE.W	D0,D1
	AND.W	#$FFF0,D0
	LSR.W	#1,D0
	ADD.W	D0,A0
	AND.L	#%1000,D1
	LSL.W	#1,D1
	LEA	ICON_DATA(PC),A3
	ADD.W	D1,A3

	REPT	7
	MOVE.W	(A3)+,D1
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	LEA	152(A0),A0
	ENDR
	MOVE.W	(A3)+,D1
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+
	AND.W	D1,(A0)+

	LEA	NUMBER_FONT(PC),A3
	MOVE.W	CURRENT_POS(PC),D0
	MOVE.L	LOGBASE(PC),A0
	ADD.L	#(80*160)+128,A0
	BSR	DRAW_4_DIGIT

	MOVE.W	SHIP_START_Z(PC),D0
	SUB.W	CURRENT_POS(PC),D0
	CMP.W	#14,D0
	BHI	.DONT_DRAW_START
	MOVE.L	LOGBASE(PC),A0
	LEA	80*160(A0),A0
	MOVE.W	SHIP_START_X(PC),D1
	BTST	#0,D1
	BEQ.S	.EVEN
	MOVEQ	#1,D3
	BRA.S	.PAST
.EVEN	MOVEQ	#0,D3
.PAST
	AND.W	#%1111111111111110,D1
	LSL.W	#2,D1
	MULU	#160*8,D0
	ADD.W	D1,D0
	ADD.W	D3,D0
	ADD.W	D0,A0
	LEA	START_ICON(PC),A1
ADDIT	SET	0
	REPT	8
	MOVE.B	(A1)+,D0
	MOVE.B	D0,ADDIT(A0)
	MOVE.B	D0,ADDIT+2(A0)
	MOVE.B	D0,ADDIT+4(A0)
	MOVE.B	D0,ADDIT+6(A0)
ADDIT	SET	ADDIT+160
	ENDR
.DONT_DRAW_START:
	RTS
START_ICON:	
	DC.B	%00111100
	DC.B	%01000010
	DC.B	%01000000
	DC.B	%00111100
	DC.B	%00000010
	DC.B	%00000010
	DC.B	%01000010
	DC.B	%00111100

COLOR_DATA_2D:
	DC.W	$FFFF,$0000,$0000,$0000,0
	DC.W	$0000,$FFFF,$0000,$0000,0
	DC.W	$FFFF,$FFFF,$0000,$0000,0
	DC.W	$0000,$0000,$FFFF,$0000,0
	DC.W	$FFFF,$0000,$FFFF,$0000,0
	DC.W	$0000,$FFFF,$FFFF,$0000,0
	DC.W	$FFFF,$FFFF,$FFFF,$0000,0
	DC.W	$0000,$0000,$0000,$FFFF,-1
	DC.W	$FFFF,$0000,$0000,$FFFF,-1
	DC.W	$0000,$FFFF,$0000,$FFFF,-1
	DC.W	$FFFF,$FFFF,$0000,$FFFF,-1
	DC.W	$0000,$0000,$FFFF,$FFFF,-1
	DC.W	$FFFF,$0000,$FFFF,$FFFF,-1
	DC.W	$0000,$FFFF,$FFFF,$FFFF,-1
	DC.W	$FFFF,$FFFF,$FFFF,$FFFF,-1
	DC.W	$0000,$FFFF,$0000,%1010101010101010,%0101010101010101
	DC.W	$FFFF,$FFFF,$0000,%1010101010101010,%0101010101010101

ICON_X:	DC.W	0
ICON_Y:	DC.W	80

ICON_DATA:
	DC.W	%0000000011111111
	DC.W	%0111111011111111
	DC.W	%0111111011111111
	DC.W	%0111111011111111
	DC.W	%0111111011111111
	DC.W	%0111111011111111
	DC.W	%0111111011111111
	DC.W	%0000000011111111

	DC.W	%1111111100000000
	DC.W	%1111111101111110
	DC.W	%1111111101111110
	DC.W	%1111111101111110
	DC.W	%1111111101111110
	DC.W	%1111111101111110
	DC.W	%1111111101111110
	DC.W	%1111111100000000


***************************************************
* THIS ROUTINE ALLOWS THE EDITING OF THE RASTERS  *
***************************************************

RASTER_LINE:	DC.W	0

RASTER_EDITOR:
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$66,D0
	BEQ	.CLEAR_RASTERS
	CMP.B	#$48,D0
	BNE.S	.NOT_UP
	TST.W	RASTER_LINE
	BEQ.S	.NOT_UP
	SUBQ.W	#1,RASTER_LINE
.NOT_UP:
	CMP.B	#$50,D0
	BNE.S	.NOT_DOWN
	CMP.W	#59,RASTER_LINE
	BEQ.S	.NOT_DOWN
	ADDQ.W	#1,RASTER_LINE
.NOT_DOWN:

	LEA	RASTERS,A6
	MOVE.W	RASTER_LINE(PC),D1
	ADD.W	D1,D1
	ADD.W	D1,A6
	MOVE.W	(A6),D1
	CMP.B	#$2,D0
	BNE.S	.NOT_1
	ADD.W	#$100,D1
.NOT_1:	CMP.B	#$3,D0
	BNE.S	.NOT_2
	ADD.W	#$010,D1
.NOT_2:	CMP.B	#$4,D0
	BNE.S	.NOT_3
	ADDQ.W	#$001,D1
.NOT_3:
	AND.W	#%0000011101110111,D1
	MOVE.W	D1,(A6)
	
	MOVE.L	LOGBASE(PC),A0
	LEA	(80*160)+64(A0),A0
	MOVE.W	(A6),D0
	LEA	NUMBER_FONT(PC),A3	
	MOVE.L	D0,D1
	AND.L	#$F,D1
	LSL.W	#4,D1
	LEA	(A3,D1.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	MOVE.L	D0,D1
	AND.L	#$F0,D1
	LEA	(A3,D1.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	MOVE.L	D0,D1
	AND.L	#$F00,D1
	LSR.W	#4,D1
	LEA	(A3,D1.W),A2
	BSR	DRAWNUMBER

	MOVE.L	LOGBASE(PC),A0
	LEA	(87*160)+80(A0),A0
	MOVE.L	A0,A1
	MOVE.L	#$FFFF0000,D1
	MOVEQ	#0,D2
	MOVE.W	#59,D0
.LOOP:
	MOVE.L	D1,(A1)+
	MOVE.L	D2,(A1)+
	LEA	152(A1),A1
	DBF	D0,.LOOP

	MOVE.W	RASTER_LINE(PC),D0
	MULU	#160,D0
	ADD.W	D0,A0
	MOVEQ	#-1,D1
	MOVE.L	D1,(A0)+
	MOVE.L	D1,(A0)+
	RTS

.CLEAR_RASTERS:
	LEA	RASTERS,A0
	MOVEQ	#0,D1
	MOVEQ	#59,D0
.LOOP1:	MOVE.W	D1,(A0)+
	DBF	D0,.LOOP1
	RTS

***************************************************
* THIS ROUTINE ALLOWS THE EDITING OF THE COLORS   *
* IN THE CURRENT PALETTE                          *
***************************************************

COLOR_EDITOR:
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$4D,D0
	BNE.S	.NOT_RIGHT
	CMP.W	#15,PALETTE_NUMBER
	BEQ.S	.NOT_RIGHT
	ADDQ.W	#1,PALETTE_NUMBER
	ADDQ.L	#2,PALETTE_POINTER
.NOT_RIGHT:
	CMP.B	#$4B,D0
	BNE.S	.NOT_LEFT
	TST.W	PALETTE_NUMBER
	BEQ.S	.NOT_LEFT
	SUBQ.W	#1,PALETTE_NUMBER
	SUBQ.L	#2,PALETTE_POINTER

.NOT_LEFT:
	MOVE.L	PALETTE_POINTER(PC),A0
	MOVE.W	(A0),D1
	CMP.B	#$2,D0
	BNE.S	.NOT_1
	ADD.W	#$100,D1
.NOT_1:	CMP.B	#$3,D0
	BNE.S	.NOT_2
	ADD.W	#$010,D1
.NOT_2:	CMP.B	#$4,D0
	BNE.S	.NOT_3
	ADDQ.W	#$001,D1
.NOT_3:
	BCLR	#3,D1
	BCLR	#7,D1
	BCLR	#11,D1
	MOVE.W	D1,(A0)
	
	MOVE.L	LOGBASE(PC),A0
	LEA	(63*160)+8(A0),A0
	LEA	9*160(A0),A1
	MOVEQ	#0,D0

ADDIT	SET	0
	REPT	16		
	MOVE.L	D0,ADDIT(A0)
	MOVE.L	D0,ADDIT+4(A0)
	MOVE.L	D0,ADDIT(A1)
	MOVE.L	D0,ADDIT+4(A1)
ADDIT	SET	ADDIT+8
	ENDR

	MOVE.W	PALETTE_NUMBER(PC),D0
	LSL.W	#3,D0
	ADD.W	D0,A0
	ADD.W	D0,A1
	MOVEQ	#-1,D0
	MOVE.L	D0,(A0)+
	MOVE.L	D0,(A0)+
	MOVE.L	D0,(A1)+
	MOVE.L	D0,(A1)+
	MOVE.L	LOGBASE(PC),A0
	LEA	(80*160)+80(A0),A0
	MOVE.L	PALETTE_POINTER(PC),A1
	MOVE.W	(A1),D0
	LEA	NUMBER_FONT(PC),A3	
	MOVE.L	D0,D1
	AND.L	#$F,D1
	LSL.W	#4,D1
	LEA	(A3,D1.W),A2
	BSR.S	DRAWNUMBER
	SUBQ.L	#8,A0
	MOVE.L	D0,D1
	AND.L	#$F0,D1
	LEA	(A3,D1.W),A2
	BSR.S	DRAWNUMBER
	SUBQ.L	#8,A0
	MOVE.L	D0,D1
	AND.L	#$F00,D1
	LSR.W	#4,D1
	LEA	(A3,D1.W),A2
	BSR.S	DRAWNUMBER

	RTS

DRAWNUMBER:
ADDIT	SET	0
	REPT	8
	MOVE.W	(A2)+,D1
	MOVE.W	D1,ADDIT(A0)
	MOVE.W	D1,ADDIT+2(A0)
	MOVE.W	D1,ADDIT+4(A0)
	MOVE.W	D1,ADDIT+6(A0)
ADDIT	SET	ADDIT+160	
	ENDR
	RTS

PALETTE_POINTER:	DC.L	PALETTE
PALETTE_NUMBER:		DC.W	0

NUMBER_FONT:
	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0101110000000010
	DC.W	%0100001100000010
	DC.W	%0100000011000010
	DC.W	%0100000000111010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0000000100000000
	DC.W	%0000001100000000
	DC.W	%0000010100000000
	DC.W	%0000100100000000
	DC.W	%0001000100000000
	DC.W	%0000000100000000
	DC.W	%0000000100000000
	DC.W	%0001111111110000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000010
	DC.W	%0000000000000100
	DC.W	%0011111111111000
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0111111111111110

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0000000000000010
	DC.W	%0000111111111100
	DC.W	%0000000000000010
	DC.W	%0000000000000010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0000100000000000
	DC.W	%0001000000000000
	DC.W	%0010000000100000
	DC.W	%0100000000100000
	DC.W	%0111111111111110
	DC.W	%0000000000100000
	DC.W	%0000000000100000
	DC.W	%0000000000100000

	DC.W	%0111111111111110
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0111111111111000
	DC.W	%0000000000000100
	DC.W	%0000000000000010
	DC.W	%0000000000000100
	DC.W	%0111111111111000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000000
	DC.W	%0111111111111000
	DC.W	%0100000000000100
	DC.W	%0100000000000010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0111111111111110
	DC.W	%0000000000000010
	DC.W	%0000000000000010
	DC.W	%0000000000011100
	DC.W	%0000000011100000
	DC.W	%0000000100000000
	DC.W	%0000000100000000
	DC.W	%0000000100000000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0010000000000100
	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000010
	DC.W	%0010000000000010
	DC.W	%0001111111111110
	DC.W	%0100000000000010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000010
	DC.W	%0100000000000010
	DC.W	%0111111111111110
	DC.W	%0100000000000010
	DC.W	%0100000000000010
	DC.W	%0100000000000010

	DC.W	%0111111111111000
	DC.W	%0100000000000100
	DC.W	%0100000000000010
	DC.W	%0111111111111100
	DC.W	%0100000000000100
	DC.W	%0100000000000010
	DC.W	%0100000000000100
	DC.W	%0111111111111000

	DC.W	%0001111111111000
	DC.W	%0010000000000100
	DC.W	%0100000000000010
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0100000000000010
	DC.W	%0010000000000100
	DC.W	%0001111111111000

	DC.W	%0111111111111000
	DC.W	%0100000000000100
	DC.W	%0100000000000010
	DC.W	%0100000000000010
	DC.W	%0100000000000010
	DC.W	%0100000000000010
	DC.W	%0100000000000100
	DC.W	%0111111111111000

	DC.W	%0111111111111110
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0111111111100000
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0111111111111110

	DC.W	%0111111111111110
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0111111111100000
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0100000000000000
	DC.W	%0100000000000000


FILENAME:	DC.B	12
		DS.B	30
		EVEN

SAVE_TEXT:	DC.B	$1B,$45,13,10,"PLEASE TYPE NAME FOR FILE SAVE.",13,10,13,10,0
SAVE_TEXT2:	DC.B	13,10,13,10,"OK, I'M NOW SAVING THAT FILE!",13,10,0
		EVEN

LOAD_TEXT:	DC.B	$1B,$45,13,10,"PLEASE TYPE NAME FOR FILE LOAD.",13,10,13,10,0
LOAD_TEXT2:	DC.B	13,10,13,10,"OK, I'M NOW LOADING THAT FILE!",13,10,0
		EVEN

*******************************************
* MAKE BACKUP OF MAP                      *
*******************************************

COPY_TO_RESERVE:
	LEA	MAP_ARRAY,A0
	LEA	RESERVE_MAP_ARRAY,A1
	MOVE.W	#(66690/2)-1,D0
.LOOP:	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOP
	RTS

*******************************************
* EXCHANGE BACKUP AND ORIGINAL            *
*******************************************

EXCHANGE_RESERVE:
	LEA	MAP_ARRAY,A0
	LEA	RESERVE_MAP_ARRAY,A1
	MOVE.W	#(66690/2)-1,D0
.LOOP:	MOVE.W	(A0),D1
	MOVE.W	(A1),D2
	MOVE.W	D2,(A0)+
	MOVE.W	D1,(A1)+
	DBF	D0,.LOOP
	RTS

*******************************************
* MAKE BACKUP OF COLORS                   *
*******************************************

COPY_COLORS_TO_RESERVE:
	LEA	COLOR_ARRAY,A0
	LEA	RESERVE_COLOR_ARRAY,A1
	MOVE.W	#(16416/2)-1,D0
.LOOP:	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOP
	RTS

WRITE_TO_DISK_SMALL:
	CLR.W	KBUFF

	BSR	COMPRESS_DATA

	MOVE.L	#SAVE_TEXT,-(SP)
	MOVE.W	#9,-(SP)
	TRAP	#1	
	ADDQ.L	#6,SP

	MOVE.B	#30,FILENAME		LIMIT TO 12 CHARACTER INPUT
	MOVE.L	#FILENAME,-(SP)
	MOVE.W	#$A,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP

	LEA	FILENAME+2(PC),A0
	MOVE.B	#0,(A0,D0.W)		ENSURE AN END 0

	MOVE.L	#SAVE_TEXT2,-(SP)
	MOVE.W	#9,-(SP)
	TRAP	#1	
	ADDQ.L	#6,SP

	MOVE.W	#0,-(SP)
	MOVE.L	#FILENAME+2,-(SP)
	MOVE.W	#$3C,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	TST.W	D0
	BMI.S	.ERROR
	MOVE.W	D0,.HANDLE

	MOVE.L	#SET_UP_DATA,-(SP)
	MOVE.L	#512,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$40,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.L	COMPRESS_LENGTH(PC),D0
	MOVE.L	#DATA_BUFFER,-(SP)
	MOVE.L	D0,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$40,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.W	.HANDLE,-(SP)
	MOVE.W	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP
	BMI.S	.ERROR
	RTS

.ERROR:
	MOVE.W	#$700,$FFFF8240.W
	MOVE.W	#32767,D0
.LOOP
	MOVEQ	#10,D1
	MULU	D0,D1
	DBF	D0,.LOOP
	RTS

.HANDLE:	DC.W	0

*********************************************
* SMALL ROUTINE TO TAKE NOTE OF DIFFERENCES *
* BETWEEN ORIGINAL AND EDITED FRACTAL       *
*********************************************

COMPRESS_DATA:
	LEA	MAP_ARRAY,A0
	LEA	RESERVE_MAP_ARRAY,A1
	LEA	DATA_BUFFER,A2
	MOVE.W	#(66690/4)-2,D0
.LOOP:	CMPM.L	(A0)+,(A1)+
	BEQ.S	.NO_DIFFERENCE
	MOVE.L	-4(A0),D1
	MOVE.L	A0,D3
	SUB.L	#MAP_ARRAY+4,D3
	LSR.L	#1,D3
	MOVE.W	D3,(A2)+
	MOVE.L	D1,(A2)+
.NO_DIFFERENCE:
	DBF	D0,.LOOP
	MOVE.W	#-1,(A2)+
	SUB.L	#DATA_BUFFER,A2
	MOVE.L	A2,COMPRESS_LENGTH
	RTS

COMPRESS_LENGTH:	DC.L	0

*********************************************
* RECREATE FRACTAL FROM COMPRESSED DATA     *
*********************************************

DECOMPRESS_DATA:
	LEA	MAP_ARRAY,A0
	LEA	DATA_BUFFER,A1
.LOOP
	MOVEQ	#0,D0
	MOVE.W	(A1)+,D0
	CMP.W	#-1,D0
	BEQ.S	.END_OF_DATA
	ADD.L	D0,D0
	MOVE.L	(A1)+,D1
	MOVE.L	D1,(A0,D0.L)
	BRA.S	.LOOP
.END_OF_DATA:
	RTS

LOAD_SMALL_MAP:
	BSET	#5,$FFFFFA09.W
	MOVE.L	OLD_KEY,$118.W
	CLR.W	KBUFF

	MOVE.L	#LOAD_TEXT,-(SP)
	MOVE.W	#9,-(SP)
	TRAP	#1	
	ADDQ.L	#6,SP

	MOVE.B	#0,$FFFF8260.W

	MOVE.B	#30,FILENAME			LIMIT TO 12 CHARACTER INPUT
	MOVE.L	#FILENAME,-(SP)
	MOVE.W	#$A,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP

	LEA	FILENAME+2(PC),A0
	MOVE.B	#0,(A0,D0.W)		ENSURE AN END 0

	MOVE.L	#LOAD_TEXT2,-(SP)
	MOVE.W	#9,-(SP)
	TRAP	#1	
	ADDQ.L	#6,SP

	MOVE.W	#0,-(SP)
	MOVE.L	#FILENAME+2,-(SP)
	MOVE.W	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	TST.W	D0
	BMI.S	.ERROR
	MOVE.W	D0,.HANDLE

	MOVE.L	#SET_UP_DATA,-(SP)
	MOVE.L	#512,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$3F,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.L	#DATA_BUFFER,-(SP)
	MOVE.L	#$FFFFF,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$3F,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.W	.HANDLE,-(SP)
	MOVE.W	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP

	BCLR	#5,$FFFFFA09.W
	MOVE.L	#KEY_VECTOR,$118.W
	BSR	CLEAR_SCREENS
	MOVE.L	#BLACK_VBL,$70.W	
	BSR	CALC_PLAY_AREA
	BSR	COPY_TO_RESERVE
	BSR	DECOMPRESS_DATA
	BRA	DRAW_REAL_3D
	
.ERROR:
	BCLR	#5,$FFFFFA09.W
	MOVE.L	#KEY_VECTOR,$118.W
	BRA	MAIN_MENU

.HANDLE:	DC.W	0

****************************************************************
* ROUTINE TO DRAW ALL THE LITTLE NUMBERS AND STUFF ON THE MENU *
****************************************************************

DO_BULLSHIT:
	LEA	NUMBER_FONT(PC),A3

	MOVE.W	WATER_LEVEL(PC),D0
	LEA	SCREEN1+(80*160)+128,A0
	BSR.S	DRAW_4_DIGIT

	MOVE.W	LAND_LEVEL(PC),D0
	LEA	SCREEN1+(88*160)+128,A0
	BSR.S	DRAW_4_DIGIT

	MOVE.W	RANDOM_FAC(PC),D0
	LEA	SCREEN1+(104*160)+128,A0
	BSR.S	DRAW_4_DIGIT

	MOVE.L	RANDOM_NUMBER(PC),D0
	LEA	SCREEN1+(96*160)+152,A0
	BSR.S	DRAW_8_DIGIT

	MOVE.W	FIRE_REPEAT(PC),D0
	LEA	SCREEN1+(128*160)+128,A0
	BSR.S	DRAW_4_DIGIT

	RTS

DRAW_4_DIGIT:
	LEA	CONVERSION_TABLE(PC),A4	
	BSR.S	DO_CONVERT
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	ADDQ.L	#8,A0
	BSR.S	DO_CONVERT
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	ADDQ.L	#8,A0
	BSR.S	DO_CONVERT
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	ADDQ.L	#8,A0
	BSR.S	DO_CONVERT
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	RTS

DO_CONVERT:
	MOVE.W	D0,D1
	MOVEQ	#0,D2
.LOOP	SUB.W	(A4),D1
	BMI.S	.NO_MORE
	ADDQ.W	#1,D2
	BRA.S	.LOOP
.NO_MORE:
	ADD.W	(A4),D1
	MOVE.W	D1,D0
	ADDQ.L	#2,A4
	RTS

DO_CONVERT2:
	MOVE.L	D0,D2
	MOVE.L	D0,D1
	LSR.L	#4,D1
	MOVE.L	D1,D0
	AND.L	#$F,D2
	RTS

DRAW_8_DIGIT:
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	SUBQ.L	#8,A0
	BSR.S	DO_CONVERT2
	LSL.W	#4,D2
	LEA	(A3,D2.W),A2
	BSR	DRAWNUMBER
	RTS

CONVERSION_TABLE:
	DC.W	1000
	DC.W	100
	DC.W	10
	DC.W	1

*************DATA AND SHIT**************************************



CURRENT_POS:	DC.W	1010,0
CURRENT_DRAW_TABLE:	DC.L	DRAW_TABLE4
LOGBASE:	DC.L	SCREEN1
PHYSBASE:	DC.L	SCREEN1
FRAME:		DC.W	0
FRAME_STORE:	DC.W	0
FRAME_COUNT:	DC.W	0
EDIT_FRAME_STORE:	DS.W	4

BLANK:		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0
		DC.L	$FFFF0000,0

DRAW_OUT_TEXT:
	LEA	LITTLE_FONT(PC),A3
	MOVEQ	#19,D7
.LINE_LOOP:
	MOVE.L	A1,A2
	MOVEQ	#19,D6
.CHAR_LOOP:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BMI.S	.PREMATURE_END
	SUB.B	#32,D0
	LSL.W	#3,D0
	LEA	(A3,D0.W),A4
	BSR.S	DRAW_CHAR	
	ADDQ.W	#1,A2
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	SUB.B	#32,D0
	LSL.W	#3,D0
	LEA	(A3,D0.W),A4
	BSR.S	DRAW_CHAR	
	ADDQ.W	#7,A2
	DBF	D6,.CHAR_LOOP
	LEA	8*160(A1),A1
	DBF	D7,.LINE_LOOP
.PREMATURE_END:
	RTS

DRAW_CHAR:
ADDIT	SET	0
	REPT	8
	MOVE.B	(A4)+,D1
	MOVE.B	D1,ADDIT(A2)
	MOVE.B	D1,ADDIT+2(A2)
	MOVE.B	D1,ADDIT+4(A2)
	MOVE.B	D1,ADDIT+6(A2)
ADDIT	SET	ADDIT+160
	ENDR
	RTS

DRAW_CHAR1:
ADDIT	SET	0
	REPT	8
	MOVE.B	(A4)+,D1
	MOVE.B	D1,ADDIT(A2)
ADDIT	SET	ADDIT+8
	ENDR
	RTS

DRAW_BIT_OF_TEXT:
	LEA	CURRENT_OBJ_TEXT(PC),A0
	LEA	CUR_TEXT_SPACE(PC),A1
	LEA	LITTLE_FONT(PC),A3
	MOVEQ	#1,D7
.LINE_LOOP:
	MOVE.L	A1,A2
	MOVEQ	#7,D6
.CHAR_LOOP:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	SUB.B	#32,D0
	LSL.W	#3,D0
	LEA	(A3,D0.W),A4
	BSR.S	DRAW_CHAR1
	ADDQ.W	#1,A2
	DBF	D6,.CHAR_LOOP
	LEA	8*8(A1),A1
	DBF	D7,.LINE_LOOP
	RTS

DRAW_OBJECT_TEXT:
	LEA	CUR_OBJECT_TEXT_SPACE(PC),A1
	LEA	LITTLE_FONT(PC),A3
	MOVE.L	A1,A2
	MOVEQ	#7,D6
.CHAR_LOOP:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	SUB.B	#32,D0
	LSL.W	#3,D0
	LEA	(A3,D0.W),A4
	BSR.S	DRAW_CHAR1
	ADDQ.W	#1,A2
	DBF	D6,.CHAR_LOOP
	RTS

CURRENT_OBJ_TEXT:
	DC.B	"CURRENT "
	DC.B	"OBJECT  "

MENU_TEXT:	
	DC.B	"       KILLING SPREE LEVEL EDITOR       "
	DC.B	"                                        "
	DC.B	"F1. 2D EDITOR        F5. RASTER EDITOR  "
	DC.B	"F2. 3D DISPLAY       F6. GAME PRESETS   "
	DC.B	"F3. COMPLETE MAP     F7. SAVE COMPRESSED"
	DC.B	"F4. COLOR EDITOR     F8. MAIN MENU      "
	DC.B	"     (C) LOST BOYS DEVELOPMENT 1991     "
	DC.B	$FF
	EVEN

MENU_TEXT2:	
	DC.B	"ESC - BACKSPACE COLORS. TAB - U HEIGHTS "
	DC.B	" H OR V FOR HORIZ OR VERT LINE OF ABOVE "
	DC.B	" F AND COLOR TO FILL AREA. C AND HEIGHT "
	DC.B	"TO MAKE A CONE. S TO SET SHIP START POS."
	DC.B	"  P POSITIONS CURRENT OBJECT. PLUS AND  " 
	DC.B	"    MINUS ON KEYPAD TO SELECT OBJECT    "
	DC.B	"   UNDO RETURNS ORIGINAL FRACTAL DATA   "
	DC.B	$FF
	EVEN

MENU_TEXT3:	
	DC.B	"          THE COLOR EDITOR              "
	DC.B	"                                        "
	DC.B	"  LEFT AND RIGHT ARROW KEYS TO SELECT   "
	DC.B	"              THE COLOR                 "
	DC.B	" KEYS 1,2 AND 3 TO CHANGE THE INDIVIDUAL" 
	DC.B	"      RED, GREEN AND BLUE SETTINGS      "
	DC.B	"                                        "
	DC.B	$FF
	EVEN

MENU_TEXT4:	
	DC.B	"          THE RASTER EDITOR             "
	DC.B	"                                        "
	DC.B	"    UP AND DOWN ARROW KEYS TO SELECT    "
	DC.B	"      THE RASTER LINE TO BE EDITED      "
	DC.B	" KEYS 1,2 AND 3 TO CHANGE THE INDIVIDUAL" 
	DC.B	"      RED, GREEN AND BLUE SETTINGS      "
	DC.B	"                                        "
	DC.B	$FF
	EVEN

MAIN_TEXT:
	DC.B	"                                        "
	DC.B	"             KILLING SPREE              "
	DC.B	"           GAME LEVEL EDITOR            "
	DC.B	"          VERSION 1.3 7.12.91           "
	DC.B	"                                        "
	DC.B	"  F1. CREATE FRACTAL LEVEL (LOSE EDITS) "
	DC.B	"  F2. CREATE FRACTAL LEVEL (KEEP EDITS) "
	DC.B	"  F3. LOAD COMPRESSED LEVEL             "
	DC.B	"  F4. FRACTAL TYPE:-                    "
MAIN_TEXT_CREATION:	EQU	*-8
	DC.B	"  F5. LANDSCAPE FILL TYPE:-             "
MAIN_TEXT_FILL:	EQU	*-8
	DC.B	"  F6. INITIAL WATER LEVEL               "
	DC.B	"  F7. INITIAL LAND LEVEL                "
	DC.B	"  F8. RANDOM SEED                       "
	DC.B	"  F9. RANDOM FACTOR                     "
	DC.B	"  F10.QUIT TO THE DESKTOP               "
	DC.B	"                                        "
	DC.B	"(C) COPYRIGHT LOST BOYS DEVELOPMENT 1991"
	DC.B	$FF
	EVEN

PRESET_TEXT:
	DC.B	"                                        "
	DC.B	"             KILLING SPREE              "
	DC.B	"          GAME PRESET EDITOR            "
	DC.B	"                                        "
	DC.B	"  1.  SET NORMAL FIRE REPEAT:-          "  
	DC.B	"  2.  LEVEL COMPLETEION TIME:-          "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"                                        "
	DC.B	"  ESC:- RETURN TO EDITOR                "
	DC.B	"                                        "
	DC.B	"(C) COPYRIGHT LOST BOYS DEVELOPMENT 1991"
	DC.B	$FF
	EVEN

CUR_TEXT_SPACE:
	DS.B	8*16
CUR_OBJECT_TEXT_SPACE:
	DS.B	8*8

LITTLE_FONT:	INCBIN	8X8_FONT.DAT
TEXT:
		DS.B	160*(56+1)
		INCBIN	TEXT.IMG
		DS.B	160*4
TEXT_PAL:
		DC.W	$0000,$0222,$0332,$0443,$0554,$0665,$0777,$0111
		DC.W	$0333,$0777,$0777,$0777,$0777,$0777,$0777,$0777
ED_PAL:
		DC.W	$0000,$0444,$0444,$0444,$0444,$0444,$0444,$0444
		DC.W	$0444,$0444,$0444,$0444,$0444,$0444,$0444,$0444
BLANK_PAL:	DS.W	16

OBJECT_LIST2:
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111,'BLANK   '

	DC.B	%11111111
	DC.B	%11101111
	DC.B	%11000111
	DC.B	%10000011
	DC.B	%00000001
	DC.B	%11101111
	DC.B	%11101111
	DC.B	%11111111,'TREE    '

	DC.B	%11000111
	DC.B	%10000011
	DC.B	%11000111
	DC.B	%11000111
	DC.B	%10000011
	DC.B	%10000011
	DC.B	%00000001
	DC.B	%00000001,'GUN TURR'

	DC.B	%11111111
	DC.B	%11011111
	DC.B	%11011111
	DC.B	%11011111
	DC.B	%11011111
	DC.B	%11000011
	DC.B	%11111111
	DC.B	%11111111,'L LASTOW'

	DC.B	%11111111
	DC.B	%11000111
	DC.B	%11011011
	DC.B	%11000111
	DC.B	%11011011
	DC.B	%11011011
	DC.B	%11111111
	DC.B	%11111111,'R LASTOW'

	DC.B	%11111111
	DC.B	%11111111
	DC.B	%01110101
	DC.B	%00100101
	DC.B	%01010101
	DC.B	%01110101
	DC.B	%11111111
	DC.B	%11111111,'MOVING W'

	DC.B	%11111111
	DC.B	%11111111
	DC.B	%01110100
	DC.B	%00100110
	DC.B	%01010101
	DC.B	%01110100
	DC.B	%11111111
	DC.B	%11111111,'MOVING W'

	DC.B	%11111111
	DC.B	%11000011
	DC.B	%10000001
	DC.B	%01101110
	DC.B	%10111001
	DC.B	%00010000
	DC.B	%10111001
	DC.B	%11111111,'TANK L  '

	DC.B	%10101111
	DC.B	%00010111
	DC.B	%10110011
	DC.B	%11100011
	DC.B	%10110011
	DC.B	%00010011
	DC.B	%00010111
	DC.B	%10101111,'TANK U  '

	DC.B	%11111111
	DC.B	%11000011
	DC.B	%10000001
	DC.B	%01110110
	DC.B	%10011101
	DC.B	%00001000
	DC.B	%10011101
	DC.B	%11111111,'TANK R  '

	DC.B	%11110101
	DC.B	%11101000
	DC.B	%11001000
	DC.B	%11001101
	DC.B	%11001111
	DC.B	%11001101
	DC.B	%11101000
	DC.B	%11110101,'TANK D  '

	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11100111
	DC.B	%11100111
	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11111111,'ROADMARK'

	DC.B	%11100111
	DC.B	%01100101
	DC.B	%11100111
	DC.B	%10100110
	DC.B	%11100111
	DC.B	%11111111
	DC.B	%10000001
	DC.B	%11000011,'VERT LAS'

	DC.B	%11000011
	DC.B	%11111111
	DC.B	%11000011
	DC.B	%11111111
	DC.B	%11000011
	DC.B	%11111111
	DC.B	%11000011
	DC.B	%11111111,'SPRING  '

	DC.B	%11111111
	DC.B	%11100111
	DC.B	%11000011
	DC.B	%10000001
	DC.B	%10000001
	DC.B	%00000000
	DC.B	%11000011
	DC.B	%11111111,'BASE    '

	DC.B	%11111111
	DC.B	%11111111
	DC.B	%00001011
	DC.B	%01111011
	DC.B	%00001011
	DC.B	%11101011
	DC.B	%00001011
	DC.B	%11111111,'DES WALL'

	DC.B	%11100100
	DC.B	%11101010
	DC.B	%11101010
	DC.B	%11011111
	DC.B	%10111111
	DC.B	%00000000
	DC.B	%10111111
	DC.B	%11011111,'MINE LAY'

	DC.B	%11010111
	DC.B	%11010111
	DC.B	%11101111
	DC.B	%11111111
	DC.B	%10110110
	DC.B	%01010010
	DC.B	%01010100
	DC.B	%10110110,'VELC ON '

	DC.B	%11010111
	DC.B	%11010111
	DC.B	%11101111
	DC.B	%11111111
	DC.B	%10110001
	DC.B	%01010111
	DC.B	%01010001
	DC.B	%10110111,'VELC OFF'

	DC.B	%11000111
	DC.B	%10000011
	DC.B	%11000111
	DC.B	%11000111
	DC.B	%10000011
	DC.B	%10000011
	DC.B	%11111111
	DC.B	%10010011,'MOVE GUN'

	DC.B	%11111111
	DC.B	%11011011
	DC.B	%10111101
	DC.B	%00000000
	DC.B	%10111101
	DC.B	%11011011
	DC.B	%11111111
	DC.B	%11111111,'WAVERS  '

	DC.B	%11111111
	DC.B	%11111111
	DC.B	%11100111
	DC.B	%11000011
	DC.B	%10000001
	DC.B	%11100111
	DC.B	%11111111
	DC.B	%11111111,'SAUCERS '

	DC.B	%11000011
	DC.B	%10000001
	DC.B	%00111100
	DC.B	%00111111
	DC.B	%00111111
	DC.B	%00111100
	DC.B	%10000001
	DC.B	%11000011,'SI COMM '

	DC.B	%11111111
	DC.B	%11100111
	DC.B	%11000011
	DC.B	%11000011
	DC.B	%11100111
	DC.B	%11000011
	DC.B	%10100101
	DC.B	%11111111,'SPACE IN'
	
CURRENT_OBJECT_POS:	DC.L	0
	
DRAW_OBJECT_LINE:
	MOVE.L	CURRENT_OBJECT_POS,A3
	MOVE.L	A1,-(A7)
	TST.B	(A3)+
	BEQ.S	.1
	BSR	DRAW_SPRITE
.1	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.2
	BSR	DRAW_SPRITE
.2	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.3
	BSR	DRAW_SPRITE
.3	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.4
	BSR	DRAW_SPRITE
.4	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.5
	BSR	DRAW_SPRITE
.5	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.6
	BSR	DRAW_SPRITE
.6	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.7
	BSR	DRAW_SPRITE
.7	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.8
	BSR	DRAW_SPRITE
.8	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.9
	BSR	DRAW_SPRITE
.9	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.10
	BSR	DRAW_SPRITE
.10
	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.11
	BSR	DRAW_SPRITE
.11
	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.12
	BSR	DRAW_SPRITE
.12
	ADD.L	#32-12,A3		
	MOVE.L	(A7)+,A1
	ADDQ.W	#1,DEPTH
	LEA	POLY_SURFACES(PC),A0
	MOVE.L	A3,CURRENT_OBJECT_POS
	RTS

DRAW_OBJECT_LINE2:
	MOVE.L	CURRENT_OBJECT_POS,A3
	MOVE.L	A1,-(A7)
	ADDQ.L	#1,A3
	TST.B	(A3)+
	BEQ.S	.1
	BSR.S	DRAW_SPRITE
.1	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.2
	BSR.S	DRAW_SPRITE
.2	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.3
	BSR.S	DRAW_SPRITE
.3	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.4
	BSR.S	DRAW_SPRITE
.4	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.5
	BSR.S	DRAW_SPRITE
.5	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.6
	BSR.S	DRAW_SPRITE
.6	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.7
	BSR.S	DRAW_SPRITE
.7	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.8
	BSR.S	DRAW_SPRITE
.8	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.9
	BSR.S	DRAW_SPRITE
.9	ADDQ.W	#4,A1
	TST.B	(A3)+
	BEQ.S	.10
	BSR.S	DRAW_SPRITE
.10
	ADD.L	#32-11,A3		
	MOVE.L	(A7)+,A1
	ADDQ.W	#1,DEPTH
	LEA	POLY_SURFACES(PC),A0
	MOVE.L	A3,CURRENT_OBJECT_POS
	RTS

DEPTH:	DC.W	0

*************************************************
* THE ROUTINE TO DRAW A SPRITE ON THE LANDSCAPE *
*************************************************

DRAW_SPRITE:
	MOVEQ	#0,D0
	MOVE.B	-1(A3),D0
	LEA	OBJECT_LIST-50(PC),A6
	MULU	#50,D0
	ADD.W	D0,A6
	MOVE.W	DEPTH(PC),D0
	ADD.W	D0,D0
	MOVE.W	DEPTH_LIST(PC,D0.W),D0		FIND WHICH SPRITE FRAME
	ADD.W	D0,A6
	MOVE.W	(A6)+,D7
	MOVE.W	(A1),D5				GET X
	MOVE.W	2(A1),D6			GET Y
	ADD.W	6(A1),D6			(AVERAGE OF 2)
	ASR.W	#1,D6
	SUB.W	D7,D6				SUBTRACT HEIGHT
	SUBQ.W	#1,D7				# LINES -1
	MOVE.L	(A6)+,A5			GET ROUTINE TO USE
	MOVE.L	(A6)+,A0			GET DATA ADDRESS
	MOVE.L	LOGBASE(PC),A6			SCREEN BASE
	BRA	SPRITE_HANDLER			RUN HANDLER

DEPTH_LIST:	DC.W	0,0,10,20,20,30,30,40,40,40

OBJECT_LIST:
************FIR TREE********************
	DC.W	16
	DC.L	SPRITE_16,TREE1+(92*8)
	DC.W	18
	DC.L	SPRITE_16,TREE1+(74*8)
	DC.W	22
	DC.L	SPRITE_16,TREE1+(52*8)
	DC.W	25
	DC.L	SPRITE_16,TREE1+(27*8)
	DC.W	27
	DC.L	SPRITE_16,TREE1+(0*8)
************TURRET TYPE1*****************
	DC.W	14
	DC.L	SPRITE_16,TURRET1+(27*16)+(59*8)
	DC.W	16
	DC.L	SPRITE_16,TURRET1+(27*16)+(43*8)
	DC.W	20
	DC.L	SPRITE_16,TURRET1+(27*16)+(23*8)
	DC.W	23
	DC.L	SPRITE_16,TURRET1+(27*16)
	DC.W	27
	DC.L	SPRITE_32,TURRET1+(0*16)
***************************************
************LASER GATE LEFT********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
***************************************
************LASER GATE RIGHT********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
***************************************
************MOVING BLOCK IND FOR DISPLAY******
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND1
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND1
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND1
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND1
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND1
***************************************
************MOVING BLOCK IND FOR DISPLAY******
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND2
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND2
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND2
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND2
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND2
***************************************
************BUGGY********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************BUGGY********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************BUGGY********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************BUGGY********************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************BUGGY********************
	DC.W	4
	DC.L	SPRITE_16,ROAD_TRACER
	DC.W	4
	DC.L	SPRITE_16,ROAD_TRACER
	DC.W	4
	DC.L	SPRITE_16,ROAD_TRACER
	DC.W	4
	DC.L	SPRITE_16,ROAD_TRACER
	DC.W	4
	DC.L	SPRITE_16,ROAD_TRACER
************LASER TOWER********************
	DC.W	6
	DC.L	SPRITE_32,LASER_TOWER+(37*16)
	DC.W	7
	DC.L	SPRITE_32,LASER_TOWER+(30*16)
	DC.W	9
	DC.L	SPRITE_32,LASER_TOWER+(21*16)
	DC.W	10
	DC.L	SPRITE_32,LASER_TOWER+(11*16)
	DC.W	11
	DC.L	SPRITE_32,LASER_TOWER
************HIGHLY SPRUNG!*******************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************BASE THINGY******************
	DC.W	8
	DC.L	SPRITE_32,BASE+(52*16)
	DC.W	10
	DC.L	SPRITE_32,BASE+(42*16)
	DC.W	12
	DC.L	SPRITE_32,BASE+(30*16)
	DC.W	14
	DC.L	SPRITE_32,BASE+(16*16)
	DC.W	16
	DC.L	SPRITE_32,BASE+(0*16)
************MOVING BLOCK IND FOR DISPLAY******
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND3
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND3
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND3
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND3
	DC.W	10
	DC.L	SPRITE_16,MOVING_IND3
************MINE LAYER*****************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************VELOCITY_COMAND******
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
************VELOCITY_COMAND******
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
	DC.W	5
	DC.L	SPRITE_16,VELOCITY_COMMAND_IND
************MOVING GUN (LEFT_RIGHT)****************
	DC.W	14
	DC.L	SPRITE_16,TURRET1+(27*16)+(59*8)
	DC.W	16
	DC.L	SPRITE_16,TURRET1+(27*16)+(43*8)
	DC.W	20
	DC.L	SPRITE_16,TURRET1+(27*16)+(23*8)
	DC.W	23
	DC.L	SPRITE_16,TURRET1+(27*16)
	DC.W	27
	DC.L	SPRITE_32,TURRET1+(0*16)
************WAVERS*****************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************MINI SAUCERS****************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************SPACE INVADER COMMANDER****************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
************SPACE INVADER****************
	DC.W	10
	DC.L	SPRITE_16,DUMMY1+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY1+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY1+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY1+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY1+(0*8)
 
	INCLUDE	E:\KSPREE.TLB\SPRITES\SPRITE_1.S

TREE1:		INCBIN	E:\KSPREE.TLB\DATA\TREE1.OBJ
TURRET1:	INCBIN	E:\KSPREE.TLB\DATA\TURRETS.OBJ
LAZER_GATE:	INCBIN	E:\KSPREE.TLB\DATA\LAZ_GATE.OBJ
DUMMY1:		INCBIN	E:\KSPREE.TLB\DATA\BUGGY.OBJ
LASER_TOWER:	INCBIN	E:\KSPREE.TLB\DATA\LAS_TOWR.OBJ
BASE:		INCBIN	E:\KSPREE.TLB\DATA\BASE.OBJ

MOVING_IND2:
		DC.W	%0000010000000000,%0000010000000000,%0000010000000000,%0000010000000000
		DC.W	%0000111000000000,%0000111000000000,%0000111000000000,%0000111000000000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000
		DC.W	%0111111111000000,%0111111111000000,%0111111111000000,%0111111111000000
		DC.W	%1111111111100000,%1111111111100000,%1111111111100000,%1111111111100000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000

MOVING_IND1:
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%1111111111100000,%1111111111100000,%1111111111100000,%1111111111100000
		DC.W	%0111111111000000,%0111111111000000,%0111111111000000,%0111111111000000
		DC.W	%0011111110000000,%0011111110000000,%0011111110000000,%0011111110000000
		DC.W	%0001111100000000,%0001111100000000,%0001111100000000,%0001111100000000
		DC.W	%0000111000000000,%0000111000000000,%0000111000000000,%0000111000000000
		DC.W	%0000010000000000,%0000010000000000,%0000010000000000,%0000010000000000

MOVING_IND3:
		DC.W	%1110101011101110,%1110101011101110,%1110101011101110,%1110101011101110
		DC.W	%1000101010100100,%1000101010100100,%1000101010100100,%1000101010100100
		DC.W	%1110111010100100,%1110111010100100,%1110111010100100,%1110111010100100
		DC.W	%0010101010100100,%0010101010100100,%0010101010100100,%0010101010100100
		DC.W	%1110101011100100,%1110101011100100,%1110101011100100,%1110101011100100
		DC.W	%0000000000000000,%0000000000000000,%0000000000000000,%0000000000000000
		DC.W	%0010000010000000,%0010000010000000,%0010000010000000,%0010000010000000
		DC.W	%1010101010100000,%1010101010100000,%1010101010100000,%1010101010100000
		DC.W	%0111000111000000,%0111000111000000,%0111000111000000,%0111000111000000
		DC.W	%0010000010000000,%0010000010000000,%0010000010000000,%0010000010000000
ROAD_TRACER:
		DC.W	%0000000110000000,%0000000110000000,0,0
		DC.W	%0000001111000000,%0000001111000000,0,0
		DC.W	%0000001111000000,%0000001111000000,0,0
		DC.W	%0000000110000000,%0000000110000000,0,0

VELOCITY_COMMAND_IND:
		DC.W	%1000101110100000,%1000101110100000,0,0
		DC.W	%1000101000100000,%1000101000100000,0,0
		DC.W	%1000101100100000,%1000101100100000,0,0
		DC.W	%0101001000100000,%0101001000100000,0,0
		DC.W	%0010001110111100,%0010001110111100,0,0

	SECTION	BSS

*****THIS IS THE ARRAY WHERE ALL THE DATA IS STORED*****

		DS.L	100
OURSTACK:	DS.L	10		ALLOW FOR SMALL ERRORS
OLDSSP:		DS.L	1
OLD_PHYS:	DS.L	1
OLD_TB:		DS.L	1
OLD_VBL:	DS.L	1
OLD_KEY:	DS.L	1
OLD_07:		DS.B	1
OLD_09:		DS.B	1
OLD_0F:		DS.B	1
OLD_13:		DS.B	1
OLD_1B:		DS.B	1
OLD_17:		DS.B	1
		EVEN
OLD_PALETTE:	DS.L	8
POLY_SURFACES:	DS.W	16*16
TAB_160:	DS.W	200
GRID_MULT_TABLE:
		DS.L	(GRID_SIZE*32)+1
GRID_MULT_TABLE_END:
MAP_ARRAY:	DS.W	(((GRID_SIZE+1)*GRID_SIZE)*16)+GRID_SIZE+1
MAP_ARRAY_END:
COLOR_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
COLOR_ARRAY_END:
OBJECT_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
OBJECT_ARRAY_END:
		EVEN
RESERVE_MAP_ARRAY:	DS.W	(((GRID_SIZE+1)*GRID_SIZE)*16)+GRID_SIZE+1
RESERVE_MAP_ARRAY_END:
RESERVE_COLOR_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
RESERVE_OBJECT_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
		EVEN
PROJ_DIVU_TAB:	DS.W	8192
PRE_CALC_TABLE:	DS.W	33*20
DRAW_TABLE4:	DS.W	(14*2)*11
PRE_CALC_PERS:	DS.B	(512)*40
DATA_BUFFER:



